/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl.helper;

import java.util.HashMap;
import java.util.Map;
import org.apache.felix.cm.impl.helper.ConfigurationMap;
import org.apache.felix.cm.impl.helper.TargetedPID;

public class ManagedServiceFactoryConfigurationMap
extends ConfigurationMap<Map<TargetedPID, Long>> {
    protected ManagedServiceFactoryConfigurationMap(String[] configuredPids) {
        super(configuredPids);
    }

    @Override
    protected Map<String, Map<TargetedPID, Long>> createMap(int size) {
        return new HashMap<String, Map<TargetedPID, Long>>(size);
    }

    @Override
    protected boolean shallTake(TargetedPID configPid, TargetedPID factoryPid, long revision) {
        Map configs = (Map)this.get(factoryPid);
        if (configs == null) {
            return true;
        }
        Long rev = (Long)configs.get(configPid);
        if (rev == null) {
            return true;
        }
        return rev < revision;
    }

    @Override
    protected boolean removeConfiguration(TargetedPID configPid, TargetedPID factoryPid) {
        Map configs = (Map)this.get(factoryPid);
        return configs != null && configs.containsKey(configPid);
    }

    @Override
    protected void record(TargetedPID configPid, TargetedPID factoryPid, long revision) {
        HashMap<TargetedPID, Long> configs = (HashMap<TargetedPID, Long>)this.get(factoryPid);
        if (configs == null) {
            configs = new HashMap<TargetedPID, Long>(4);
        }
        if (revision < 0L) {
            configs.remove(configPid);
        } else {
            configs.put(configPid, revision);
        }
        if (configs.size() == 0) {
            configs = null;
        }
        this.put(factoryPid, configs);
    }
}

