/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.common.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.plugin.spi.DestinationSpi;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.Hashtable;

public class DestinationHandler
extends PacketHandler {
    private Logger logger = Globals.getLogger();
    private static boolean DEBUG = false;

    @Override
    public boolean handle(IMQConnection con, Packet msg) throws BrokerException {
        Hashtable<String, Object> hash;
        Packet pkt;
        block38: {
            block37: {
                int status = 200;
                String reason = null;
                pkt = new Packet(con.useDirectBuffers());
                pkt.setConsumerID(msg.getConsumerID());
                hash = new Hashtable<String, Object>();
                Hashtable props = null;
                try {
                    props = msg.getProperties();
                }
                catch (Exception ex) {
                    assert (false);
                    this.logger.logStack(32, "B3100", (Object)"Unable to create/destroy destination - no properties", (Throwable)ex);
                    throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Can not handle create/destroy destination"));
                }
                String destination = (String)props.get("JMQDestination");
                Integer inttype = (Integer)props.get("JMQDestType");
                int type = inttype == null ? 0 : inttype;
                pkt.setPacketType(msg.getPacketType() + 1);
                if (msg.getPacketType() == 34) {
                    if (DEBUG) {
                        this.logger.log(1, "ConsumerHandler: handle() [ Received AddDestination message {0}]", (Object)msg.toString());
                    }
                    assert (destination != null);
                    assert (inttype != null);
                    if (con.isAdminConnection()) {
                        type |= 0x20A0;
                    }
                    assert (pkt.getPacketType() == 35);
                    try {
                        DestinationSpi d = null;
                        if (DestType.isTemporary((int)type)) {
                            boolean storeTemps = con.getConnectionUID().getCanReconnect();
                            long reconnectTime = con.getReconnectInterval();
                            DestinationSpi[] ds = Globals.getCoreLifecycle().createTempDestination(con.getPartitionedStore(), destination, type, con.getConnectionUID(), storeTemps, reconnectTime);
                            d = ds[0];
                            if (con.getConnectionUID().equals((Object)d.getConnectionUID())) {
                                con.attachTempDestination(d.getDestinationUID());
                            }
                        } else if (!destination.startsWith("MQ_")) {
                            if (DestinationUID.isWildcard(destination)) {
                                pkt.setWildcard(true);
                            } else {
                                DestinationSpi[] ds = Globals.getCoreLifecycle().getDestination(con.getPartitionedStore(), destination, type, true, !con.isAdminConnection());
                                d = ds[0];
                            }
                        }
                        hash.put("JMQDestType", type);
                        hash.put("JMQDestUID", destination);
                        hash.put("JMQValidateXMLSchema", this.isXMLSchemaValidationOn(d));
                        String uris = this.getXMLSchemaURIList(d);
                        if (uris != null) {
                            hash.put("JMQXMLSchemaURIList", uris);
                        }
                        hash.put("JMQReloadXMLSchemaOnFailure", this.getReloadXMLSchemaOnFailure(d));
                    }
                    catch (BrokerException ex) {
                        status = ex.getStatusCode();
                        reason = ex.getMessage();
                        if (status != 409) {
                            this.logger.log(16, "B2007", (Object)destination, (Throwable)ex);
                        } else if (DEBUG) {
                            this.logger.log(4, "B2007", (Object)destination, (Throwable)ex);
                        }
                    }
                    catch (IOException ex) {
                        status = 500;
                        reason = ex.getMessage();
                        this.logger.log(16, "B2007", (Object)destination, (Throwable)ex);
                    }
                } else {
                    assert (msg.getPacketType() == 36);
                    assert (pkt.getPacketType() == 37);
                    DestinationSpi d = null;
                    try {
                        DestinationUID rmuid = DestinationUID.getUID(destination, DestType.isQueue((int)type));
                        if (destination == null) {
                            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "protocol error,  destination is null"), 404);
                        }
                        DestinationSpi[] ds = Globals.getCoreLifecycle().getDestination(con.getPartitionedStore(), rmuid);
                        d = ds[0];
                        assert (d != null);
                        Globals.getCoreLifecycle().removeDestination(con.getPartitionedStore(), rmuid, true, Globals.getBrokerResources().getString("B0067", (Object)con.getConnectionUID()));
                        con.detachTempDestination(rmuid);
                    }
                    catch (BrokerException ex) {
                        status = ex.getStatusCode();
                        reason = ex.getMessage();
                        this.logger.log(16, "B2008", (Object)destination, (Throwable)ex);
                    }
                    catch (IOException ex) {
                        status = 500;
                        reason = ex.getMessage();
                        this.logger.log(16, "B2008", (Object)destination, (Throwable)ex);
                    }
                }
                hash.put("JMQStatus", status);
                if (reason != null) {
                    hash.put("JMQReason", reason);
                }
                IMQBasicConnection cfr_ignored_0 = (IMQBasicConnection)con;
                if (IMQBasicConnection.getDumpPacket()) break block37;
                IMQBasicConnection cfr_ignored_1 = (IMQBasicConnection)con;
                if (!IMQBasicConnection.getDumpOutPacket()) break block38;
            }
            hash.put("JMQReqID", msg.getSysMessageID().toString());
        }
        pkt.setProperties(hash);
        con.sendControlMessage(pkt);
        return true;
    }

    private boolean isXMLSchemaValidationOn(DestinationSpi d) {
        if (d == null) {
            return false;
        }
        return d.validateXMLSchemaEnabled();
    }

    private String getXMLSchemaURIList(DestinationSpi d) {
        String ret = null;
        if (d == null) {
            return null;
        }
        ret = d.getXMLSchemaUriList();
        return ret;
    }

    private boolean getReloadXMLSchemaOnFailure(DestinationSpi d) {
        if (d == null) {
            return false;
        }
        return d.reloadXMLSchemaOnFailure();
    }
}

