/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient.protocol.direct;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PacketDispatcher;
import com.sun.messaging.jmq.io.ReadWritePacket;
import com.sun.messaging.jmq.jmsclient.ConnectionHandler;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.runtime.ClientRuntime;
import com.sun.messaging.jmq.jmsclient.runtime.impl.ClientRuntimeImpl;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQDualThreadConnection;
import com.sun.messaging.jmq.jmsservice.DirectBrokerConnection;
import com.sun.messaging.jmq.jmsservice.HandOffQueue;
import jakarta.jms.JMSException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class DirectConnectionHandler
implements ConnectionHandler {
    private HandOffQueue inBoundQ = null;
    private HandOffQueue outBoundQ = null;
    private DirectBrokerConnection directConnection = null;
    private volatile boolean isClosed = false;
    private static boolean directDebug = Boolean.getBoolean("imq.direct.debug");

    @Override
    public boolean isDirectMode() {
        return true;
    }

    public DirectConnectionHandler() throws JMSException {
        this.init();
        if (directDebug) {
            ConnectionImpl.getConnectionLogger().info("Direct connection handler created...");
        }
    }

    private void init() throws JMSException {
        try {
            boolean isdirect = ClientRuntime.getRuntime().isEmbeddedBrokerRunning();
            if (!isdirect) {
                throw new RuntimeException("Direct broker not initialized for this client runtime.");
            }
            ClientRuntimeImpl runtime = (ClientRuntimeImpl)ClientRuntime.getRuntime();
            this.directConnection = runtime.createDirectConnection();
            this.inBoundQ = this.directConnection.getBrokerToClientQueue();
            this.outBoundQ = this.directConnection.getClientToBrokerQueue();
        }
        catch (Exception e) {
            e.printStackTrace();
            JMSException jmse = new JMSException(e.getMessage());
            jmse.setLinkedException(e);
            throw jmse;
        }
    }

    public void setReplyDispatcher(PacketDispatcher rd) {
        ((IMQDualThreadConnection)this.directConnection).setReplyDispatcher(rd);
    }

    @Override
    public void writePacket(ReadWritePacket pkt) throws IOException {
        try {
            if (this.isClosed) {
                throw new IOException("Connection is closed.");
            }
            pkt.updateSequenceNumber();
            pkt.updateTimestamp();
            pkt.updateBuffers();
            ReadWritePacket newPkt = (ReadWritePacket)pkt.clone();
            this.outBoundQ.put((Object)newPkt);
            if (directDebug) {
                System.out.println("Direct connection wrote pkt..." + String.valueOf(newPkt));
                System.out.flush();
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            IOException ioe = new IOException(e.getMessage());
            throw ioe;
        }
    }

    @Override
    public ReadWritePacket readPacket() throws IOException {
        ReadWritePacket pkt = null;
        try {
            if (!this.isClosed) {
                pkt = (ReadWritePacket)this.inBoundQ.take();
            }
            if (directDebug) {
                System.out.println("Direct connection read pkt..." + String.valueOf(pkt));
                System.out.flush();
            }
            if (this.isClosed) {
                throw new IOException("Connection is closed.");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return pkt;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        ReadWritePacket pkt = new ReadWritePacket();
        pkt.setPacketType(0);
        this.isClosed = true;
        try {
            this.inBoundQ.put((Object)pkt);
        }
        catch (Exception e) {
            IOException ioe = new IOException(e.getMessage());
            throw ioe;
        }
    }

    @Override
    public String getBrokerAddress() {
        return "localhost";
    }

    @Override
    public String getBrokerHostName() {
        return "localhost";
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return null;
    }

    @Override
    public int getLocalPort() throws IOException {
        return 0;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    public Packet fetchReply() {
        return ((IMQDualThreadConnection)this.directConnection).fetchReply();
    }

    @Override
    public void configure(Properties configuration) throws IOException {
    }
}

