/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient.protocol;

import com.sun.messaging.jmq.io.ReadWritePacket;
import com.sun.messaging.jmq.jmsclient.ConnectionHandler;
import com.sun.messaging.jmq.jmsclient.Debug;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public abstract class SocketConnectionHandler
implements ConnectionHandler {
    private static String defaultBufferSize = "2048";
    private boolean debug = Debug.debug;
    private InputStream is = null;
    private OutputStream os = null;

    protected abstract void closeSocket() throws IOException;

    @Override
    public boolean isDirectMode() {
        return false;
    }

    @Override
    public ReadWritePacket readPacket() throws IOException {
        ReadWritePacket pkt = new ReadWritePacket();
        pkt.readPacket(this.is);
        return pkt;
    }

    @Override
    public void writePacket(ReadWritePacket pkt) throws IOException {
        pkt.writePacket(this.os);
    }

    @Override
    public void configure(Properties configuration) throws IOException {
        String bufsize;
        String prop = this.getProperty(configuration, "imqOutputBuffer", "true");
        if (prop.equals("true")) {
            bufsize = this.getProperty(configuration, "imqOutputBufferSize", defaultBufferSize);
            int outSize = Integer.parseInt(bufsize);
            this.os = new BufferedOutputStream(this.getOutputStream(), outSize);
            if (this.debug) {
                Debug.println("buffered output stream, buffer size: " + outSize);
            }
        } else {
            this.os = this.getOutputStream();
        }
        prop = this.getProperty(configuration, "imqInputBuffer", "true");
        if (prop.equals("true")) {
            bufsize = this.getProperty(configuration, "imqInputBufferSize", "2048");
            int inSize = Integer.parseInt(bufsize);
            this.is = new BufferedInputStream(this.getInputStream(), inSize);
            if (this.debug) {
                Debug.println("buffered input stream, buffer size: " + inSize);
            }
        } else {
            this.is = this.getInputStream();
        }
    }

    private String getProperty(Properties configuration, String propname, String propdefault) {
        String propval = (String)configuration.get(propname);
        if (propval == null) {
            propval = System.getProperty(propname);
        }
        return propval == null ? propdefault : propval;
    }

    @Override
    public void close() throws IOException {
        this.getInputStream().close();
        this.is.close();
        this.os.close();
        this.closeSocket();
    }
}

