/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.client;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class SslContextConfigurator {
    public static final String TRUST_STORE_PROVIDER = "javax.net.ssl.trustStoreProvider";
    public static final String KEY_STORE_PROVIDER = "javax.net.ssl.keyStoreProvider";
    public static final String TRUST_STORE_FILE = "javax.net.ssl.trustStore";
    public static final String KEY_STORE_FILE = "javax.net.ssl.keyStore";
    public static final String TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    public static final String KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    public static final String TRUST_STORE_TYPE = "javax.net.ssl.trustStoreType";
    public static final String KEY_STORE_TYPE = "javax.net.ssl.keyStoreType";
    public static final String KEY_FACTORY_MANAGER_ALGORITHM = "ssl.KeyManagerFactory.algorithm";
    public static final String TRUST_FACTORY_MANAGER_ALGORITHM = "ssl.TrustManagerFactory.algorithm";
    private static final Logger LOGGER = Logger.getLogger(SslContextConfigurator.class.getName());
    public static final SslContextConfigurator DEFAULT_CONFIG = new SslContextConfigurator();
    private String trustStoreProvider;
    private String keyStoreProvider;
    private String trustStoreType;
    private String keyStoreType;
    private char[] trustStorePassword;
    private char[] keyStorePassword;
    private char[] keyPassword;
    private String trustStoreFile;
    private String keyStoreFile;
    private byte[] trustStoreBytes;
    private byte[] keyStoreBytes;
    private String trustManagerFactoryAlgorithm;
    private String keyManagerFactoryAlgorithm;
    private String securityProtocol = "TLS";

    public SslContextConfigurator() {
        this(true);
    }

    public SslContextConfigurator(boolean readSystemProperties) {
        if (readSystemProperties) {
            this.retrieve(System.getProperties());
        }
    }

    public SslContextConfigurator setTrustStoreProvider(String trustStoreProvider) {
        this.trustStoreProvider = trustStoreProvider;
        return this;
    }

    public SslContextConfigurator setKeyStoreProvider(String keyStoreProvider) {
        this.keyStoreProvider = keyStoreProvider;
        return this;
    }

    public SslContextConfigurator setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
        return this;
    }

    public SslContextConfigurator setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
        return this;
    }

    public SslContextConfigurator setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword.toCharArray();
        return this;
    }

    public SslContextConfigurator setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword.toCharArray();
        return this;
    }

    public SslContextConfigurator setKeyStorePassword(char[] keyStorePassword) {
        this.keyStorePassword = (char[])keyStorePassword.clone();
        return this;
    }

    public SslContextConfigurator setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword.toCharArray();
        return this;
    }

    public SslContextConfigurator setKeyPassword(char[] keyPassword) {
        this.keyPassword = (char[])keyPassword.clone();
        return this;
    }

    public SslContextConfigurator setTrustStoreFile(String trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
        this.trustStoreBytes = null;
        return this;
    }

    public SslContextConfigurator setTrustStoreBytes(byte[] trustStoreBytes) {
        this.trustStoreBytes = (byte[])trustStoreBytes.clone();
        this.trustStoreFile = null;
        return this;
    }

    public SslContextConfigurator setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
        this.keyStoreBytes = null;
        return this;
    }

    public SslContextConfigurator setKeyStoreBytes(byte[] keyStoreBytes) {
        this.keyStoreBytes = (byte[])keyStoreBytes.clone();
        this.keyStoreFile = null;
        return this;
    }

    public SslContextConfigurator setTrustManagerFactoryAlgorithm(String trustManagerFactoryAlgorithm) {
        this.trustManagerFactoryAlgorithm = trustManagerFactoryAlgorithm;
        return this;
    }

    public SslContextConfigurator setKeyManagerFactoryAlgorithm(String keyManagerFactoryAlgorithm) {
        this.keyManagerFactoryAlgorithm = keyManagerFactoryAlgorithm;
        return this;
    }

    public SslContextConfigurator setSecurityProtocol(String securityProtocol) {
        this.securityProtocol = securityProtocol;
        return this;
    }

    public boolean validateConfiguration() {
        return this.validateConfiguration(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateConfiguration(boolean needsKeyStore) {
        boolean valid = true;
        if (this.keyStoreBytes != null || this.keyStoreFile != null) {
            try {
                KeyStore keyStore = this.keyStoreProvider != null ? KeyStore.getInstance(this.keyStoreType != null ? this.keyStoreType : KeyStore.getDefaultType(), this.keyStoreProvider) : KeyStore.getInstance(this.keyStoreType != null ? this.keyStoreType : KeyStore.getDefaultType());
                InputStream keyStoreInputStream = null;
                try {
                    if (this.keyStoreBytes != null) {
                        keyStoreInputStream = new ByteArrayInputStream(this.keyStoreBytes);
                    } else if (!this.keyStoreFile.equals("NONE")) {
                        keyStoreInputStream = new FileInputStream(this.keyStoreFile);
                    }
                    keyStore.load(keyStoreInputStream, this.keyStorePassword);
                }
                finally {
                    try {
                        if (keyStoreInputStream != null) {
                            keyStoreInputStream.close();
                        }
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.FINEST, "Could not close key store file", e);
                    }
                }
                String kmfAlgorithm = this.keyManagerFactoryAlgorithm;
                if (kmfAlgorithm == null) {
                    kmfAlgorithm = System.getProperty(KEY_FACTORY_MANAGER_ALGORITHM, KeyManagerFactory.getDefaultAlgorithm());
                }
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(kmfAlgorithm);
                keyManagerFactory.init(keyStore, this.keyPassword != null ? this.keyPassword : this.keyStorePassword);
            }
            catch (KeyStoreException e) {
                LOGGER.log(Level.FINE, "Error initializing key store", e);
                valid = false;
            }
            catch (CertificateException e) {
                LOGGER.log(Level.FINE, "Key store certificate exception.", e);
                valid = false;
            }
            catch (UnrecoverableKeyException e) {
                LOGGER.log(Level.FINE, "Key store unrecoverable exception.", e);
                valid = false;
            }
            catch (FileNotFoundException e) {
                LOGGER.log(Level.FINE, "Can't find key store file: " + this.keyStoreFile, e);
                valid = false;
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Error loading key store from file: " + this.keyStoreFile, e);
                valid = false;
            }
            catch (NoSuchAlgorithmException e) {
                LOGGER.log(Level.FINE, "Error initializing key manager factory (no such algorithm)", e);
                valid = false;
            }
            catch (NoSuchProviderException e) {
                LOGGER.log(Level.FINE, "Error initializing key store (no such provider)", e);
                valid = false;
            }
        } else {
            valid &= !needsKeyStore;
        }
        if (this.trustStoreBytes != null || this.trustStoreFile != null) {
            try {
                KeyStore trustStore = this.trustStoreProvider != null ? KeyStore.getInstance(this.trustStoreType != null ? this.trustStoreType : KeyStore.getDefaultType(), this.trustStoreProvider) : KeyStore.getInstance(this.trustStoreType != null ? this.trustStoreType : KeyStore.getDefaultType());
                InputStream trustStoreInputStream = null;
                try {
                    if (this.trustStoreBytes != null) {
                        trustStoreInputStream = new ByteArrayInputStream(this.trustStoreBytes);
                    } else if (!this.trustStoreFile.equals("NONE")) {
                        trustStoreInputStream = new FileInputStream(this.trustStoreFile);
                    }
                    trustStore.load(trustStoreInputStream, this.trustStorePassword);
                }
                finally {
                    try {
                        if (trustStoreInputStream != null) {
                            trustStoreInputStream.close();
                        }
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.FINEST, "Could not close key store file", e);
                    }
                }
                String tmfAlgorithm = this.trustManagerFactoryAlgorithm;
                if (tmfAlgorithm == null) {
                    tmfAlgorithm = System.getProperty(TRUST_FACTORY_MANAGER_ALGORITHM, TrustManagerFactory.getDefaultAlgorithm());
                }
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(tmfAlgorithm);
                trustManagerFactory.init(trustStore);
            }
            catch (KeyStoreException e) {
                LOGGER.log(Level.FINE, "Error initializing trust store", e);
                valid = false;
            }
            catch (CertificateException e) {
                LOGGER.log(Level.FINE, "Trust store certificate exception.", e);
                valid = false;
            }
            catch (FileNotFoundException e) {
                LOGGER.log(Level.FINE, "Can't find trust store file: " + this.trustStoreFile, e);
                valid = false;
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Error loading trust store from file: " + this.trustStoreFile, e);
                valid = false;
            }
            catch (NoSuchAlgorithmException e) {
                LOGGER.log(Level.FINE, "Error initializing trust manager factory (no such algorithm)", e);
                valid = false;
            }
            catch (NoSuchProviderException e) {
                LOGGER.log(Level.FINE, "Error initializing trust store (no such provider)", e);
                valid = false;
            }
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLContext createSSLContext() {
        SSLContext sslContext = null;
        try {
            TrustManagerFactory trustManagerFactory = null;
            KeyManagerFactory keyManagerFactory = null;
            if (this.keyStoreBytes != null || this.keyStoreFile != null) {
                try {
                    KeyStore keyStore = this.keyStoreProvider != null ? KeyStore.getInstance(this.keyStoreType != null ? this.keyStoreType : KeyStore.getDefaultType(), this.keyStoreProvider) : KeyStore.getInstance(this.keyStoreType != null ? this.keyStoreType : KeyStore.getDefaultType());
                    InputStream keyStoreInputStream = null;
                    try {
                        if (this.keyStoreBytes != null) {
                            keyStoreInputStream = new ByteArrayInputStream(this.keyStoreBytes);
                        } else if (!this.keyStoreFile.equals("NONE")) {
                            keyStoreInputStream = new FileInputStream(this.keyStoreFile);
                        }
                        keyStore.load(keyStoreInputStream, this.keyStorePassword);
                    }
                    finally {
                        try {
                            if (keyStoreInputStream != null) {
                                keyStoreInputStream.close();
                            }
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.FINEST, "Could not close key store file", e);
                        }
                    }
                    String kmfAlgorithm = this.keyManagerFactoryAlgorithm;
                    if (kmfAlgorithm == null) {
                        kmfAlgorithm = System.getProperty(KEY_FACTORY_MANAGER_ALGORITHM, KeyManagerFactory.getDefaultAlgorithm());
                    }
                    keyManagerFactory = KeyManagerFactory.getInstance(kmfAlgorithm);
                    keyManagerFactory.init(keyStore, this.keyPassword != null ? this.keyPassword : this.keyStorePassword);
                }
                catch (KeyStoreException e) {
                    LOGGER.log(Level.FINE, "Error initializing key store", e);
                }
                catch (CertificateException e) {
                    LOGGER.log(Level.FINE, "Key store certificate exception.", e);
                }
                catch (UnrecoverableKeyException e) {
                    LOGGER.log(Level.FINE, "Key store unrecoverable exception.", e);
                }
                catch (FileNotFoundException e) {
                    LOGGER.log(Level.FINE, "Can't find key store file: " + this.keyStoreFile, e);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "Error loading key store from file: " + this.keyStoreFile, e);
                }
                catch (NoSuchAlgorithmException e) {
                    LOGGER.log(Level.FINE, "Error initializing key manager factory (no such algorithm)", e);
                }
                catch (NoSuchProviderException e) {
                    LOGGER.log(Level.FINE, "Error initializing key store (no such provider)", e);
                }
            }
            if (this.trustStoreBytes != null || this.trustStoreFile != null) {
                try {
                    KeyStore trustStore = this.trustStoreProvider != null ? KeyStore.getInstance(this.trustStoreType != null ? this.trustStoreType : KeyStore.getDefaultType(), this.trustStoreProvider) : KeyStore.getInstance(this.trustStoreType != null ? this.trustStoreType : KeyStore.getDefaultType());
                    InputStream trustStoreInputStream = null;
                    try {
                        if (this.trustStoreBytes != null) {
                            trustStoreInputStream = new ByteArrayInputStream(this.trustStoreBytes);
                        } else if (!this.trustStoreFile.equals("NONE")) {
                            trustStoreInputStream = new FileInputStream(this.trustStoreFile);
                        }
                        trustStore.load(trustStoreInputStream, this.trustStorePassword);
                    }
                    finally {
                        try {
                            if (trustStoreInputStream != null) {
                                trustStoreInputStream.close();
                            }
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.FINEST, "Could not close trust store file", e);
                        }
                    }
                    String tmfAlgorithm = this.trustManagerFactoryAlgorithm;
                    if (tmfAlgorithm == null) {
                        tmfAlgorithm = System.getProperty(TRUST_FACTORY_MANAGER_ALGORITHM, TrustManagerFactory.getDefaultAlgorithm());
                    }
                    trustManagerFactory = TrustManagerFactory.getInstance(tmfAlgorithm);
                    trustManagerFactory.init(trustStore);
                }
                catch (KeyStoreException e) {
                    LOGGER.log(Level.FINE, "Error initializing trust store", e);
                }
                catch (CertificateException e) {
                    LOGGER.log(Level.FINE, "Trust store certificate exception.", e);
                }
                catch (FileNotFoundException e) {
                    LOGGER.log(Level.FINE, "Can't find trust store file: " + this.trustStoreFile, e);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "Error loading trust store from file: " + this.trustStoreFile, e);
                }
                catch (NoSuchAlgorithmException e) {
                    LOGGER.log(Level.FINE, "Error initializing trust manager factory (no such algorithm)", e);
                }
                catch (NoSuchProviderException e) {
                    LOGGER.log(Level.FINE, "Error initializing trust store (no such provider)", e);
                }
            }
            String secProtocol = "TLS";
            if (this.securityProtocol != null) {
                secProtocol = this.securityProtocol;
            }
            sslContext = SSLContext.getInstance(secProtocol);
            sslContext.init(keyManagerFactory != null ? keyManagerFactory.getKeyManagers() : null, trustManagerFactory != null ? trustManagerFactory.getTrustManagers() : null, null);
        }
        catch (KeyManagementException e) {
            LOGGER.log(Level.FINE, "Key management error.", e);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.log(Level.FINE, "Error initializing algorithm.", e);
        }
        return sslContext;
    }

    public SslContextConfigurator retrieve(Properties props) {
        this.trustStoreProvider = props.getProperty(TRUST_STORE_PROVIDER);
        this.keyStoreProvider = props.getProperty(KEY_STORE_PROVIDER);
        this.trustStoreType = props.getProperty(TRUST_STORE_TYPE);
        this.keyStoreType = props.getProperty(KEY_STORE_TYPE);
        this.trustStorePassword = (char[])(props.getProperty(TRUST_STORE_PASSWORD) != null ? props.getProperty(TRUST_STORE_PASSWORD).toCharArray() : null);
        this.keyStorePassword = (char[])(props.getProperty(KEY_STORE_PASSWORD) != null ? props.getProperty(KEY_STORE_PASSWORD).toCharArray() : null);
        this.trustStoreFile = props.getProperty(TRUST_STORE_FILE);
        this.keyStoreFile = props.getProperty(KEY_STORE_FILE);
        this.trustStoreBytes = null;
        this.keyStoreBytes = null;
        this.securityProtocol = "TLS";
        return this;
    }
}

