/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.config.serverbeans.AvailabilityService;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.session.PersistenceType;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.web.LogFacade;
import org.glassfish.web.config.serverbeans.ManagerProperties;
import org.glassfish.web.config.serverbeans.SessionConfig;
import org.glassfish.web.config.serverbeans.SessionManager;
import org.glassfish.web.config.serverbeans.SessionProperties;
import org.glassfish.web.config.serverbeans.StoreProperties;
import org.glassfish.web.config.serverbeans.WebContainer;
import org.glassfish.web.config.serverbeans.WebContainerAvailability;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service
@PerLookup
public class ServerConfigLookup {
    private static final Logger _logger = LogFacade.getLogger();
    @Inject
    @Named(value="default-instance-name")
    private Config configBean;
    @Inject
    private ClassLoaderHierarchy clh;

    public SessionManager getInstanceSessionManager() {
        if (this.configBean == null) {
            return null;
        }
        WebContainer webContainerBean = (WebContainer)this.configBean.getExtensionByType(WebContainer.class);
        if (webContainerBean == null) {
            return null;
        }
        SessionConfig sessionConfigBean = webContainerBean.getSessionConfig();
        if (sessionConfigBean == null) {
            return null;
        }
        return sessionConfigBean.getSessionManager();
    }

    public ManagerProperties getInstanceSessionManagerManagerProperties() {
        SessionManager smBean = this.getInstanceSessionManager();
        if (smBean == null) {
            return null;
        }
        return smBean.getManagerProperties();
    }

    public StoreProperties getInstanceSessionManagerStoreProperties() {
        SessionManager smBean = this.getInstanceSessionManager();
        if (smBean == null) {
            return null;
        }
        return smBean.getStoreProperties();
    }

    public SessionProperties getInstanceSessionProperties() {
        if (this.configBean == null) {
            return null;
        }
        WebContainer webContainerBean = (WebContainer)this.configBean.getExtensionByType(WebContainer.class);
        if (webContainerBean == null) {
            return null;
        }
        SessionConfig sessionConfigBean = webContainerBean.getSessionConfig();
        if (sessionConfigBean == null) {
            return null;
        }
        return sessionConfigBean.getSessionProperties();
    }

    protected AvailabilityService getAvailabilityService() {
        return this.configBean.getAvailabilityService();
    }

    public boolean getAvailabilityEnabledFromConfig() {
        AvailabilityService as = this.getAvailabilityService();
        if (as == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "AS-WEB-GLUE-00116");
            }
            return false;
        }
        if (as.getAvailabilityEnabled() == null) {
            return false;
        }
        return this.toBoolean(as.getAvailabilityEnabled());
    }

    private WebContainerAvailability getWebContainerAvailability() {
        AvailabilityService as = this.getAvailabilityService();
        return as != null ? (WebContainerAvailability)as.getExtensionByType(WebContainerAvailability.class) : null;
    }

    protected String getWebContainerAvailabilityPropertyString(String propName) {
        return this.getWebContainerAvailabilityPropertyString(propName, null);
    }

    protected String getWebContainerAvailabilityPropertyString(String propName, String defaultValue) {
        WebContainerAvailability wcAvailabilityBean = this.getWebContainerAvailability();
        if (wcAvailabilityBean == null) {
            return defaultValue;
        }
        List props = wcAvailabilityBean.getProperty();
        if (props == null) {
            return defaultValue;
        }
        for (Property prop : props) {
            String name = prop.getName();
            String value = prop.getValue();
            if (!name.equalsIgnoreCase(propName)) continue;
            return value;
        }
        return defaultValue;
    }

    public boolean getWebContainerAvailabilityEnabledFromConfig() {
        boolean globalAvailabilityEnabled = this.getAvailabilityEnabledFromConfig();
        WebContainerAvailability was = this.getWebContainerAvailability();
        if (was == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "AS-WEB-GLUE-00117");
            }
            return false;
        }
        if (was.getAvailabilityEnabled() == null) {
            return globalAvailabilityEnabled;
        }
        return this.toBoolean(was.getAvailabilityEnabled());
    }

    public boolean isSsoFailoverEnabledFromConfig() {
        WebContainerAvailability webContainerAvailabilityBean = this.getWebContainerAvailability();
        if (webContainerAvailabilityBean == null) {
            return false;
        }
        if (webContainerAvailabilityBean.getSsoFailoverEnabled() == null) {
            return false;
        }
        return this.toBoolean(webContainerAvailabilityBean.getSsoFailoverEnabled());
    }

    public boolean calculateWebAvailabilityEnabledFromConfig() {
        boolean globalAvailability = this.getAvailabilityEnabledFromConfig();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "AS-WEB-GLUE-00118", globalAvailability);
        }
        boolean webContainerAvailability = this.getWebContainerAvailabilityEnabledFromConfig();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "AS-WEB-GLUE-00119", webContainerAvailability);
        }
        return globalAvailability && webContainerAvailability;
    }

    public boolean calculateWebAvailabilityEnabledFromConfig(WebModule ctx) {
        DeployCommandParameters params;
        boolean waEnabled = this.calculateWebAvailabilityEnabledFromConfig();
        boolean webModuleAvailability = false;
        DeploymentContext dc = ctx.getWebModuleConfig().getDeploymentContext();
        if (dc != null && (params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class)) != null) {
            webModuleAvailability = params.availabilityenabled;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "AS-WEB-GLUE-00120", webModuleAvailability);
        }
        return waEnabled && webModuleAvailability;
    }

    public boolean getAsyncReplicationFromConfig(WebModule ctx) {
        DeployCommandParameters params;
        boolean asyncReplication = true;
        DeploymentContext dc = ctx.getWebModuleConfig().getDeploymentContext();
        if (dc != null && (params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class)) != null) {
            asyncReplication = params.asyncreplication;
        }
        return asyncReplication;
    }

    public PersistenceType getPersistenceTypeFromConfig() {
        String persistenceTypeString = null;
        PersistenceType persistenceType = null;
        WebContainerAvailability webContainerAvailabilityBean = this.getWebContainerAvailability();
        if (webContainerAvailabilityBean == null) {
            return null;
        }
        persistenceTypeString = webContainerAvailabilityBean.getPersistenceType();
        if (persistenceTypeString != null) {
            persistenceType = PersistenceType.parseType(persistenceTypeString);
        }
        if (persistenceType != null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "AS-WEB-GLUE-00121", persistenceType.getType());
            }
        } else if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "AS-WEB-GLUE-00122");
        }
        return persistenceType;
    }

    public String getPersistenceFrequencyFromConfig() {
        WebContainerAvailability webContainerAvailabilityBean = this.getWebContainerAvailability();
        if (webContainerAvailabilityBean == null) {
            return null;
        }
        return webContainerAvailabilityBean.getPersistenceFrequency();
    }

    public String getPersistenceScopeFromConfig() {
        WebContainerAvailability webContainerAvailabilityBean = this.getWebContainerAvailability();
        if (webContainerAvailabilityBean == null) {
            return null;
        }
        return webContainerAvailabilityBean.getPersistenceScope();
    }

    public boolean getDisableJreplicaFromConfig() {
        WebContainerAvailability webContainerAvailabilityBean = this.getWebContainerAvailability();
        if (webContainerAvailabilityBean == null) {
            return false;
        }
        return this.toBoolean(webContainerAvailabilityBean.getDisableJreplica());
    }

    protected Boolean toBoolean(String value) {
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on") || value.equalsIgnoreCase("1")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    Class loadClass(String className) throws Exception {
        return this.clh.getCommonClassLoader().loadClass(className);
    }
}

