/*
 * Decompiled with CFR 0.152.
 */
package org.obeonetwork.m2doc.services;

import java.awt.Color;
import java.io.IOException;
import java.util.Locale;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.acceleo.annotations.api.documentation.Documentation;
import org.eclipse.acceleo.annotations.api.documentation.Example;
import org.eclipse.acceleo.annotations.api.documentation.Param;
import org.eclipse.acceleo.annotations.api.documentation.ServiceProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.obeonetwork.m2doc.element.MStyle;
import org.obeonetwork.m2doc.element.MTable;
import org.obeonetwork.m2doc.element.impl.MStyleImpl;
import org.obeonetwork.m2doc.element.impl.MTableImpl;
import org.obeonetwork.m2doc.element.impl.MTextImpl;

@ServiceProvider(value="Services available for Excel. See [document examples](https://github.com/ObeoNetwork/M2Doc/tree/master/tests/org.obeonetwork.m2doc.tests/resources/excelServices).")
public class ExcelServices {
    private static final int MASK = 255;
    private URIConverter uriConverter;
    private final URI templateURI;

    public ExcelServices(URIConverter uriConverter, URI templateURI) {
        this.uriConverter = uriConverter;
        this.templateURI = templateURI;
    }

    @Documentation(value="Insert a table from an Excel .xlsx file.", params={@Param(name="uri", value="The Excel .xlsx file uri, it can be relative to the template"), @Param(name="sheetName", value="The sheet name"), @Param(name="topLeftCellAdress", value="The top left cell address"), @Param(name="bottomRightCellAdress", value="The bottom right cell address")}, result="insert the table", examples={@Example(expression="'excel.xlsx'.asTable('Feuil1', 'C3', 'F7')", result="insert the table from 'excel.xlsx'")})
    public MTable asTable(String uriStr, String sheetName, String topLeftCellAdress, String bottomRightCellAdress) throws IOException {
        return this.asTable(uriStr, sheetName, topLeftCellAdress, bottomRightCellAdress, null);
    }

    @Documentation(value="Insert a table from an Excel .xlsx file.", params={@Param(name="uri", value="The Excel .xlsx file uri, it can be relative to the template"), @Param(name="sheetName", value="The sheet name"), @Param(name="topLeftCellAdress", value="The top left cell address"), @Param(name="bottomRightCellAdress", value="The bottom right cell address"), @Param(name="languageTag", value="The language tag for the locale")}, result="insert the table", examples={@Example(expression="'excel.xlsx'.asTable('Feuil1', 'C3', 'F7', 'fr-FR')", result="insert the table from 'excel.xlsx'")})
    public MTable asTable(String uriStr, String sheetName, String topLeftCellAdress, String bottomRightCellAdress, String languageTag) throws IOException {
        MTableImpl res = new MTableImpl();
        URI xlsxURI = URI.createURI((String)uriStr, (boolean)false);
        URI uri = xlsxURI.resolve(this.templateURI);
        Throwable throwable = null;
        Object var10_11 = null;
        try (XSSFWorkbook workbook = new XSSFWorkbook(this.uriConverter.createInputStream(uri));){
            XSSFFormulaEvaluator evaluator = new XSSFFormulaEvaluator(workbook);
            XSSFSheet sheet = workbook.getSheet(sheetName);
            if (sheet == null) {
                throw new IllegalArgumentException(String.format("The sheet %s doesn't exist in %s.", sheetName, uri));
            }
            Locale locale = languageTag != null ? Locale.forLanguageTag(languageTag) : Locale.getDefault();
            DataFormatter dataFormatter = new DataFormatter(locale);
            CellAddress start = new CellAddress(topLeftCellAdress);
            CellAddress end = new CellAddress(bottomRightCellAdress);
            int rowIndex = start.getRow();
            while (rowIndex <= end.getRow()) {
                XSSFRow row;
                if ((row = sheet.getRow(rowIndex++)) != null) {
                    MTableImpl.MRowImpl mRow = new MTableImpl.MRowImpl();
                    int cellIndex = start.getColumn();
                    while (cellIndex <= end.getColumn()) {
                        XSSFCell cell;
                        if ((cell = row.getCell(cellIndex++)) != null) {
                            MStyle style = this.getStyle(cell);
                            MTextImpl text = new MTextImpl(dataFormatter.formatCellValue((Cell)cell, (FormulaEvaluator)evaluator), style);
                            Color background = this.getColor(cell.getCellStyle().getFillForegroundColorColor());
                            MTableImpl.MCellImpl mCell = new MTableImpl.MCellImpl(text, background);
                            mRow.getCells().add(mCell);
                            continue;
                        }
                        mRow.getCells().add(this.createEmptyCell());
                    }
                    res.getRows().add(mRow);
                    continue;
                }
                int length = end.getColumn() - start.getColumn() + 1;
                res.getRows().add(this.createEmptyRow(length));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return res;
    }

    private MTable.MRow createEmptyRow(int length) {
        MTableImpl.MRowImpl res = new MTableImpl.MRowImpl();
        int i = 0;
        while (i < length) {
            res.getCells().add(this.createEmptyCell());
            ++i;
        }
        return res;
    }

    private MTableImpl.MCellImpl createEmptyCell() {
        return new MTableImpl.MCellImpl(new MTextImpl("", null), null);
    }

    private MStyle getStyle(XSSFCell cell) {
        XSSFCellStyle style = cell.getCellStyle();
        XSSFFont font = style.getFont();
        int modifiers = 0;
        if (font.getBold()) {
            modifiers |= 1;
        }
        if (font.getItalic()) {
            modifiers |= 2;
        }
        if (font.getStrikeout()) {
            modifiers |= 8;
        }
        if (font.getUnderline() != 0) {
            modifiers |= 4;
        }
        return new MStyleImpl(font.getFontName(), font.getFontHeightInPoints(), this.getColor(font.getXSSFColor()), null, modifiers);
    }

    private Color getColor(XSSFColor color) {
        Color res;
        if (color != null && color.getRGB() != null) {
            byte[] rgb = color.getRGB();
            int r = rgb[0] & 0xFF;
            int g = rgb[1] & 0xFF;
            int b = rgb[2] & 0xFF;
            res = new Color(r, g, b);
        } else {
            res = null;
        }
        return res;
    }
}

