/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceAction;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class OpenResourceAction
extends WorkspaceAction
implements IResourceChangeListener {
    public static final String ID = "org.eclipse.ui.OpenResourceAction";

    @Deprecated
    public OpenResourceAction(Shell shell) {
        super(shell, IDEWorkbenchMessages.OpenResourceAction_text);
        this.initAction();
    }

    public OpenResourceAction(IShellProvider provider) {
        super(provider, IDEWorkbenchMessages.OpenResourceAction_text);
        this.initAction();
    }

    private void initAction() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.open_resource_action_context");
        this.setToolTipText(IDEWorkbenchMessages.OpenResourceAction_toolTip);
        this.setId(ID);
    }

    private int countClosedProjects() {
        IProject[] projects;
        int count = 0;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (!project.isOpen()) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    @Override
    protected String getOperationMessage() {
        if (this.getActionResources().size() > 1) {
            return IDEWorkbenchMessages.OpenResourceAction_operationMessage_plural;
        }
        return IDEWorkbenchMessages.OpenResourceAction_operationMessage;
    }

    @Override
    protected String getProblemsMessage() {
        return IDEWorkbenchMessages.OpenResourceAction_problemMessage;
    }

    @Override
    protected String getProblemsTitle() {
        return IDEWorkbenchMessages.OpenResourceAction_dialogTitle;
    }

    private boolean hasOtherClosedProjects() {
        int closedInSelection = 0;
        for (IResource iResource : this.getSelectedResources()) {
            if (((IProject)iResource).isOpen()) continue;
            ++closedInSelection;
        }
        return closedInSelection < this.countClosedProjects();
    }

    @Override
    protected void invokeOperation(IResource resource, IProgressMonitor monitor) throws CoreException {
        ((IProject)resource).open(128, monitor);
    }

    private boolean promptToOpenWithReferences() {
        String key;
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        String value = store.getString(key = "OPEN_REQUIRED_PROJECTS");
        if ("always".equals(value)) {
            return true;
        }
        if ("never".equals(value)) {
            return false;
        }
        String message = IDEWorkbenchMessages.OpenResourceAction_openRequiredProjects;
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)this.getShell(), (String)IDEWorkbenchMessages.Question, (String)message, null, (boolean)false, (IPreferenceStore)store, (String)key);
        int result = dialog.getReturnCode();
        if (result == 1 || result == -1) {
            throw new OperationCanceledException();
        }
        return dialog.getReturnCode() == 2;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta;
        List<? extends IResource> sel = this.getSelectedResources();
        if (this.selectionIsOfType(4) && (delta = event.getDelta()) != null) {
            IResourceDelta[] projDeltas;
            IResourceDelta[] iResourceDeltaArray = projDeltas = delta.getAffectedChildren(4);
            int n = projDeltas.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta projDelta = iResourceDeltaArray[n2];
                if ((projDelta.getFlags() & 0x4000) != 0 && sel.contains(projDelta.getResource())) {
                    this.selectionChanged(this.getStructuredSelection());
                    return;
                }
                ++n2;
            }
        }
    }

    @Override
    public void run() {
        try {
            this.runOpenWithReferences();
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    private void runOpenWithReferences() {
        final ArrayList<? extends IResource> resources = new ArrayList<IResource>(this.getActionResources());
        WorkspaceJob job = new WorkspaceJob(OpenResourceAction.removeMnemonics((String)this.getText())){
            private boolean openProjectReferences;
            private boolean hasPrompted;
            private boolean canceled;
            {
                super($anonymous0);
                this.openProjectReferences = true;
                this.hasPrompted = false;
                this.canceled = false;
            }

            private void doOpenWithReferences(IProject project, IProgressMonitor mon) throws CoreException {
                int n;
                if (!project.exists() || project.isOpen()) {
                    return;
                }
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)mon, (int)(this.openProjectReferences ? 2 : 1));
                project.open(128, (IProgressMonitor)subMonitor.split(1));
                IProject[] references = project.getReferencedProjects();
                if (!this.hasPrompted) {
                    this.openProjectReferences = false;
                    IProject[] iProjectArray = references;
                    n = references.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject reference = iProjectArray[n2];
                        if (reference.exists() && !reference.isOpen()) {
                            this.openProjectReferences = true;
                            break;
                        }
                        ++n2;
                    }
                    if (this.openProjectReferences && OpenResourceAction.this.hasOtherClosedProjects()) {
                        Display.getDefault().syncExec(() -> {
                            try {
                                this.openProjectReferences = OpenResourceAction.this.promptToOpenWithReferences();
                            }
                            catch (OperationCanceledException operationCanceledException) {
                                this.canceled = true;
                            }
                            this.hasPrompted = true;
                        });
                        if (this.canceled) {
                            throw new OperationCanceledException();
                        }
                    }
                }
                if (this.openProjectReferences) {
                    SubMonitor loopMonitor = subMonitor.split(1).setWorkRemaining(references.length);
                    IProject[] iProjectArray = references;
                    int n3 = references.length;
                    n = 0;
                    while (n < n3) {
                        IProject reference = iProjectArray[n];
                        this.doOpenWithReferences(reference, (IProgressMonitor)loopMonitor.split(1));
                        ++n;
                    }
                }
            }

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)OpenResourceAction.this.countClosedProjects());
                subMonitor.setTaskName(OpenResourceAction.this.getOperationMessage());
                for (IResource resource : resources) {
                    IProject project;
                    if (!(resource instanceof IProject) || !(project = (IProject)resource).exists() || project.isOpen()) continue;
                    this.doOpenWithReferences(project, (IProgressMonitor)subMonitor.split(1));
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.setUser(true);
        job.schedule();
    }

    @Override
    protected boolean shouldPerformResourcePruning() {
        return false;
    }

    @Override
    protected boolean updateSelection(IStructuredSelection s) {
        this.setText(IDEWorkbenchMessages.OpenResourceAction_text);
        this.setToolTipText(IDEWorkbenchMessages.OpenResourceAction_toolTip);
        if (!this.selectionIsOfType(4)) {
            return false;
        }
        boolean hasClosedProjects = false;
        for (IResource iResource : this.getSelectedResources()) {
            if (((IProject)iResource).isOpen()) continue;
            if (hasClosedProjects) {
                this.setText(IDEWorkbenchMessages.OpenResourceAction_text_plural);
                this.setToolTipText(IDEWorkbenchMessages.OpenResourceAction_toolTip_plural);
                break;
            }
            hasClosedProjects = true;
        }
        return hasClosedProjects;
    }
}

