/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jdt.ui;

import net.sourceforge.plantuml.jdt.Activator;
import net.sourceforge.plantuml.jdt.ui.JdtPlantUmlView;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ProjectClassDiagramPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String GENERATE_PACKAGES_KEY = "generatePackages";
    public static final String PACKAGE_STYLE_KEY = "packageStyle";
    private Button generatePackagesButton;
    private Combo packageStyleSelector;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout(1, false));
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        Group packageGenerationGroup = new Group(panel, 0);
        packageGenerationGroup.setText("Package generation");
        packageGenerationGroup.setLayout((Layout)new GridLayout(2, false));
        this.generatePackagesButton = new Button((Composite)packageGenerationGroup, 32);
        this.generatePackagesButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.generatePackagesButton.setText("Generate packages");
        this.generatePackagesButton.setSelection(preferenceStore.getBoolean(GENERATE_PACKAGES_KEY));
        Label packageStyleLabel = new Label((Composite)packageGenerationGroup, 0);
        packageStyleLabel.setText("Style: ");
        this.packageStyleSelector = new Combo((Composite)packageGenerationGroup, 8);
        this.packageStyleSelector.setItems(JdtPlantUmlView.ALL_PACKAGE_STYLES);
        String currentPackageStyle = preferenceStore.getString(PACKAGE_STYLE_KEY);
        if (currentPackageStyle == null || currentPackageStyle.length() == 0) {
            currentPackageStyle = JdtPlantUmlView.ALL_PACKAGE_STYLES[0];
        }
        int i = 0;
        while (i < JdtPlantUmlView.ALL_PACKAGE_STYLES.length) {
            if (currentPackageStyle.equals(JdtPlantUmlView.ALL_PACKAGE_STYLES[i])) {
                this.packageStyleSelector.select(i);
                break;
            }
            ++i;
        }
        return panel;
    }

    protected void performDefaults() {
        this.generatePackagesButton.setSelection(false);
        this.packageStyleSelector.select(0);
    }

    public boolean performOk() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        preferenceStore.setValue(GENERATE_PACKAGES_KEY, this.generatePackagesButton.getSelection());
        preferenceStore.setValue(PACKAGE_STYLE_KEY, JdtPlantUmlView.ALL_PACKAGE_STYLES[this.packageStyleSelector.getSelectionIndex()]);
        return true;
    }
}

