/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.util;

import org.eclipse.jdt.core.dom.AST;

public class ASTHelper {
    private static boolean isNodeTypeSupportedInAST(AST ast, int nodeType) {
        switch (nodeType) {
            case 49: 
            case 100: 
            case 101: {
                return ast.apiLevel() >= 14;
            }
            case 102: {
                return ast.apiLevel() >= 15;
            }
            case 62: 
            case 103: {
                return ast.isPreviewEnabled();
            }
        }
        return true;
    }

    private static boolean isModifierSupportedInAST(AST ast, int modifier) {
        switch (modifier) {
            case 512: 
            case 4096: {
                return ast.isPreviewEnabled();
            }
        }
        return true;
    }

    public static boolean isYieldNodeSupportedInAST(AST ast) {
        return ASTHelper.isNodeTypeSupportedInAST(ast, 101);
    }

    public static boolean isSwitchExpressionNodeSupportedInAST(AST ast) {
        return ASTHelper.isNodeTypeSupportedInAST(ast, 100);
    }

    public static boolean isTextBlockNodeSupportedInAST(AST ast) {
        return ASTHelper.isNodeTypeSupportedInAST(ast, 102);
    }

    public static boolean isSwitchCaseExpressionsSupportedInAST(AST ast) {
        return ASTHelper.isNodeTypeSupportedInAST(ast, 49);
    }

    public static boolean isRecordDeclarationNodeSupportedInAST(AST ast) {
        return ASTHelper.isNodeTypeSupportedInAST(ast, 103);
    }

    public static boolean isSealedTypeSupportedInAST(AST ast) {
        return ASTHelper.isModifierSupportedInAST(ast, 512);
    }
}

