/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.parameters;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.comma.actions.actions.Action;
import org.eclipse.comma.behavior.behavior.TriggeredTransition;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.impl.InterfaceImpl;
import org.eclipse.comma.evaluator.ETransition;
import org.eclipse.comma.evaluator.EVariable;
import org.eclipse.comma.evaluator.EVariableCollection;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.Variable;
import org.eclipse.comma.parameters.parameters.Parameters;
import org.eclipse.comma.parameters.parameters.Params;
import org.eclipse.comma.parameters.parameters.StateParams;
import org.eclipse.comma.parameters.parameters.TriggerParams;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;

public class ParametersCollection {
    final LinkedHashMap<String, ArrayList<EVariableCollection>> lookup = new LinkedHashMap();

    public ParametersCollection(List<Parameters> parameters) {
        for (Parameters parameter : parameters) {
            EVariableCollection variables = new EVariableCollection();
            String itf = parameter.getInterface().getName();
            if (parameter == null) continue;
            for (Variable var : parameter.getVars()) {
                variables.add(var);
            }
            for (Action action : parameter.getInitActions()) {
                variables.apply((Object)action, variables);
            }
            for (TriggerParams triggerParams : parameter.getTriggerParams()) {
                String trigger = triggerParams.getEvent().getName();
                List inParameterNames = triggerParams.getEvent().getParameters().stream().filter(p -> p.getDirection() == DIRECTION.IN || p.getDirection() == DIRECTION.INOUT).map(p -> p.getName()).collect(Collectors.toList());
                for (StateParams entry : triggerParams.getStateParams()) {
                    String state = entry.getState().getName();
                    String key = String.valueOf(itf) + "_" + trigger + "_" + state;
                    this.lookup.put(key, new ArrayList());
                    for (Params params : entry.getParams()) {
                        EVariableCollection parametersSet = new EVariableCollection();
                        for (Expression param : params.getValue()) {
                            parametersSet.add((String)inParameterNames.get(params.getValue().indexOf((Object)param)), EVariable.fromExpression((Expression)param, (EVariableCollection)variables));
                        }
                        this.lookup.get(key).add(parametersSet);
                    }
                }
            }
        }
    }

    public List<EVariableCollection> getParameters(ETransition eTransition) {
        TriggeredTransition transition = (TriggeredTransition)eTransition.transition;
        String trigger = transition.getTrigger().getName();
        String itf = ((InterfaceImpl)eTransition.machine.eContainer()).getName();
        String state = eTransition.state.getName();
        String key = String.valueOf(itf) + "_" + trigger + "_" + state;
        ArrayList<EVariableCollection> parameters = new ArrayList<EVariableCollection>();
        if (this.lookup.containsKey(key)) {
            parameters = this.lookup.get(key);
        }
        if (parameters.isEmpty()) {
            parameters.add(new EVariableCollection());
        }
        return parameters;
    }
}

