/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.impl;

import com.google.common.collect.AbstractIterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.common.types.access.IMirror;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.common.types.access.impl.IndexedJvmTypeAccess;
import org.eclipse.xtext.common.types.access.impl.PrimitiveMirror;
import org.eclipse.xtext.common.types.access.impl.PrimitiveTypeFactory;
import org.eclipse.xtext.common.types.access.impl.TypeResourceServices;

public abstract class AbstractJvmTypeProvider
implements IJvmTypeProvider,
Resource.Factory {
    private final ResourceSet resourceSet;
    private final PrimitiveTypeFactory primitiveTypeFactory;
    private final IndexedJvmTypeAccess indexedJvmTypeAccess;
    protected final TypeResourceServices services;

    @Deprecated
    protected AbstractJvmTypeProvider(ResourceSet resourceSet, IndexedJvmTypeAccess indexedJvmTypeAccess) {
        this(resourceSet, indexedJvmTypeAccess, null);
    }

    protected AbstractJvmTypeProvider(ResourceSet resourceSet, IndexedJvmTypeAccess indexedJvmTypeAccess, TypeResourceServices services) {
        if (resourceSet == null) {
            throw new IllegalArgumentException("resourceSet may not be null");
        }
        this.indexedJvmTypeAccess = indexedJvmTypeAccess;
        this.resourceSet = resourceSet;
        this.registerProtocol(resourceSet);
        this.primitiveTypeFactory = new PrimitiveTypeFactory();
        this.services = services;
    }

    protected void registerProtocol(ResourceSet resourceSet) {
        resourceSet.getResourceFactoryRegistry().getProtocolToFactoryMap().put("java", this);
    }

    @Override
    public abstract JvmType findTypeByName(String var1);

    protected boolean isBinaryNestedTypeDelimiter(String name, boolean binaryNestedTypeDelimiter) {
        return binaryNestedTypeDelimiter || name.indexOf(36) >= 0 || name.indexOf(46) < 0;
    }

    @Override
    public abstract JvmType findTypeByName(String var1, boolean var2);

    public TypeResource createResource(URI uri) {
        TypeResource result = this.doCreateResource(uri);
        IMirror createMirror = this.createMirror(uri);
        if (createMirror != null) {
            result.setMirror(createMirror);
        }
        return result;
    }

    protected TypeResource doCreateResource(URI uri) {
        TypeResource result = new TypeResource(uri);
        result.setTypeResourceServices(this.services);
        result.setIndexedJvmTypeAccess(this.indexedJvmTypeAccess);
        return result;
    }

    @Override
    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public IMirror createMirror(URI resourceURI) {
        if (resourceURI.hasFragment()) {
            throw new IllegalArgumentException("Cannot create mirror for uri '" + resourceURI.toString() + "'");
        }
        String name = resourceURI.path();
        if ("/Primitives".equals(name)) {
            return new PrimitiveMirror(this.primitiveTypeFactory);
        }
        if (!name.startsWith("/Objects/")) {
            throw new IllegalArgumentException("Invalid resource uri '" + resourceURI.toString() + "'");
        }
        name = name.substring("/Objects/".length());
        return this.createMirrorForFQN(name);
    }

    protected abstract IMirror createMirrorForFQN(String var1);

    public IndexedJvmTypeAccess getIndexedJvmTypeAccess() {
        return this.indexedJvmTypeAccess;
    }

    protected JvmType findNestedType(JvmDeclaredType outer, List<String> segments, int i) {
        Iterable<JvmDeclaredType> nestedTypesByName = outer.findAllNestedTypesByName(segments.get(i));
        for (JvmDeclaredType nestedType : nestedTypesByName) {
            if (i == segments.size() - 1) {
                return nestedType;
            }
            JvmType result = this.findNestedType(nestedType, segments, i + 1);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static class ClassNameVariants
    extends AbstractIterator<String> {
        private StringBuilder buffer;
        private int index;

        public ClassNameVariants(String initial) {
            this.buffer = new StringBuilder(initial);
            this.index = this.buffer.length();
        }

        protected String computeNext() {
            int newIndex = this.buffer.lastIndexOf(".", this.index);
            if (newIndex == -1) {
                return (String)this.endOfData();
            }
            this.index = newIndex - 1;
            this.buffer.setCharAt(newIndex, '$');
            return this.buffer.toString();
        }
    }
}

