/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.commands;

import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.model.AttributeInheritMode;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.libraryElement.Color;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.IVarElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.libraryElement.TypedConfigureableObject;
import org.eclipse.fordiac.ide.model.typelibrary.DeviceTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.ResourceTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.systemconfiguration.Messages;
import org.eclipse.fordiac.ide.systemconfiguration.commands.ResourceCreateCommand;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.util.ColorHelper;
import org.eclipse.fordiac.ide.util.YUV;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.RGB;

public class DeviceCreateCommand
extends Command {
    private static final String DEFAULT_RESOURCE_TYPE = "EMB_RES";
    private static final String DEFAULT_RESOURCE_FULL_TYPE = "iec61499::system::EMB_RES";
    private static final String CREATE_DEVICE_LABEL = Messages.DeviceCreateCommand_LABEL_CreateDevice;
    private final DeviceTypeEntry entry;
    private final SystemConfiguration parent;
    private final Position pos;
    private Device device;

    public Device getDevice() {
        return this.device;
    }

    public DeviceCreateCommand(DeviceTypeEntry entry, SystemConfiguration parent, Rectangle bounds) {
        this.entry = entry;
        this.parent = parent;
        this.pos = CoordinateConverter.INSTANCE.createPosFromScreenCoordinates(bounds.x, bounds.y);
        this.setLabel(CREATE_DEVICE_LABEL);
    }

    public boolean canExecute() {
        return this.entry != null && this.parent != null;
    }

    public void execute() {
        this.createDevice();
        this.device.setTypeEntry((TypeEntry)this.entry);
        CommonElementImporter.createParameters((IVarElement)this.device);
        this.setDeviceProfile();
        this.device.setPosition(this.pos);
        this.parent.getDevices().add((Object)this.device);
        this.device.setName(NameRepository.createUniqueName((INamedElement)this.device, (String)this.entry.getType().getName()));
        AttributeInheritMode.copyAttributeValuesFromType((TypedConfigureableObject)this.device);
        this.createResource();
    }

    private void setDeviceProfile() {
        String profile = this.device.getType().getProfile() != null && !"".equals(this.device.getType().getProfile()) ? this.device.getType().getProfile() : Platform.getPreferencesService().getString("org.eclipse.fordiac.ide.ui", "P_DEFAULT_COMPLIANCE_PROFILE", "", null);
        this.device.setProfile(profile);
    }

    protected void createDevice() {
        this.device = LibraryElementFactory.eINSTANCE.createDevice();
        this.device.setColor(this.createRandomDeviceColor());
    }

    private void createResource() {
        for (Resource res : this.entry.getType().getResource()) {
            ResourceCreateCommand cmd = null;
            if (res.getTypeEntry() != null) {
                cmd = new ResourceCreateCommand((ResourceTypeEntry)res.getTypeEntry(), this.device, true);
                cmd.execute();
                Resource copy = cmd.getResource();
                copy.setName(res.getName());
                continue;
            }
            FordiacLogHelper.logInfo((String)("Referenced Resource Type: " + (res.getName() != null ? res.getName() : "N/A") + (String)(res.getTypeEntry() != null ? " (" + res.getTypeName() + ") " : "(N/A)") + " not found. Please check whether your palette contains that type and add it manually to your device!"));
        }
        this.createDefaultResource();
    }

    private void createDefaultResource() {
        ResourceTypeEntry type = null;
        if (this.device.getType().getName().contains("FBRT") || this.device.getType().getName().contains("FRAME")) {
            type = this.getResourceType("PANEL_RESOURCE");
        } else {
            type = this.getResourceType(DEFAULT_RESOURCE_FULL_TYPE);
            if (type == null) {
                type = this.getResourceType(DEFAULT_RESOURCE_TYPE);
            }
        }
        if (type != null) {
            ResourceCreateCommand cmd = new ResourceCreateCommand(type, this.device, false);
            cmd.execute();
        }
    }

    private ResourceTypeEntry getResourceType(String resTypeName) {
        return this.device.getTypeEntry().getTypeLibrary().getResourceTypeEntry(resTypeName);
    }

    private Color createRandomDeviceColor() {
        Color randomColor;
        boolean exist;
        ArrayList<YUV> existingColors = new ArrayList<YUV>();
        for (Device dev : this.parent.getDevices()) {
            Color devcolor = dev.getColor();
            existingColors.add(new YUV(new RGB(devcolor.getRed(), devcolor.getGreen(), devcolor.getBlue())));
        }
        if (existingColors.isEmpty()) {
            return ColorHelper.getStartingColor();
        }
        block1: do {
            randomColor = ColorHelper.createRandomColor();
            YUV randYUV = new YUV(new RGB(randomColor.getRed(), randomColor.getGreen(), randomColor.getBlue()));
            exist = false;
            for (YUV yuv : existingColors) {
                if (!randYUV.nearbyColor(yuv)) continue;
                exist = true;
                continue block1;
            }
        } while (exist);
        return randomColor;
    }

    public void redo() {
        if (this.parent != null) {
            this.parent.getDevices().add((Object)this.device);
        }
    }

    public void undo() {
        if (this.parent != null) {
            this.parent.getDevices().remove((Object)this.device);
        }
    }
}

