/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.segment.properties;

import java.util.List;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.libraryElement.CommunicationConfiguration;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.systemconfiguration.CommunicationConfigurationDetails;
import org.eclipse.fordiac.ide.systemconfiguration.segment.Messages;
import org.eclipse.fordiac.ide.systemconfiguration.segment.commands.ChangeTsnCycleTimeCommand;
import org.eclipse.fordiac.ide.systemconfiguration.segment.commands.ChangeTsnWindowDurationCommand;
import org.eclipse.fordiac.ide.systemconfiguration.segment.commands.ChangeTsnWindowOrderCommand;
import org.eclipse.fordiac.ide.systemconfiguration.segment.commands.CreateTsnWindowCommand;
import org.eclipse.fordiac.ide.systemconfiguration.segment.commands.DeleteTsnWindowCommand;
import org.eclipse.fordiac.ide.systemconfiguration.segment.communication.CommunicationFactory;
import org.eclipse.fordiac.ide.systemconfiguration.segment.communication.TsnConfiguration;
import org.eclipse.fordiac.ide.systemconfiguration.segment.communication.TsnWindow;
import org.eclipse.fordiac.ide.systemconfiguration.segment.providers.TsnWindowLabelProvider;
import org.eclipse.fordiac.ide.systemconfiguration.segment.widget.MappedFbMenu;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.ui.widget.AddDeleteReorderListWidget;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class TsnDetails
extends CommunicationConfigurationDetails {
    private static final String NAME_COL = "name";
    private static final String VALUE_COL = "value";
    private static final String TYPE_COL = "type";
    private static final String COMMENT_COL = "comment";

    public Composite createUi(Composite parent, CommunicationConfiguration config, CommandExecutor executor, TabbedPropertySheetWidgetFactory widgetFactory) {
        TsnConfiguration tsnConfig = config == null ? CommunicationFactory.eINSTANCE.createTsnConfiguration() : (TsnConfiguration)config;
        Composite detailsComp = widgetFactory.createComposite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(detailsComp);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)detailsComp);
        TsnDetails.createCycleTimeArea(widgetFactory, tsnConfig, detailsComp, executor);
        TsnDetails.createTsnWindowArea(widgetFactory, tsnConfig, detailsComp, executor);
        return detailsComp;
    }

    private static void createCycleTimeArea(TabbedPropertySheetWidgetFactory widgetFactory, TsnConfiguration tsnConfig, Composite detailsComp, CommandExecutor executor) {
        Label cycleTimeLbl = widgetFactory.createLabel(detailsComp, Messages.TsnDetails_CycleTime);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)cycleTimeLbl);
        Text cycleTimeValue = widgetFactory.createText(detailsComp, String.valueOf(tsnConfig.getCycleTime()));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)cycleTimeValue);
        cycleTimeValue.requestLayout();
        Label msLbl = widgetFactory.createLabel(detailsComp, Messages.TsnDetails_MS);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)msLbl);
        cycleTimeValue.addModifyListener(event -> {
            try {
                int newCycleTimeValue = Integer.parseInt(cycleTimeValue.getText());
                executor.executeCommand((Command)new ChangeTsnCycleTimeCommand(tsnConfig, newCycleTimeValue));
            }
            catch (NumberFormatException e) {
                FordiacLogHelper.logWarning((String)"Could not parse cycle time value!", (Exception)e);
            }
        });
    }

    private static void createTsnWindowArea(TabbedPropertySheetWidgetFactory widgetFactory, TsnConfiguration tsnConfig, Composite detailsComp, CommandExecutor executor) {
        AddDeleteReorderListWidget buttons = new AddDeleteReorderListWidget();
        buttons.createControls(detailsComp, (FormToolkit)widgetFactory);
        TableViewer windowViewer = TableWidgetFactory.createTableViewer((Composite)detailsComp);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 1).applyTo((Control)windowViewer.getTable());
        Table table = windowViewer.getTable();
        TsnDetails.configureTableLayout(table);
        windowViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        windowViewer.setLabelProvider((IBaseLabelProvider)new TsnWindowLabelProvider());
        windowViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)});
        windowViewer.setColumnProperties(new String[]{NAME_COL, VALUE_COL, TYPE_COL, COMMENT_COL});
        windowViewer.setCellModifier((ICellModifier)new TimeSlotCellModifier(windowViewer, executor));
        MappedFbMenu.addContextMenu(windowViewer);
        windowViewer.setInput(tsnConfig.getWindows());
        TsnDetails.configureButtonList(windowViewer, buttons, tsnConfig, executor);
    }

    private static void configureButtonList(TableViewer windowViewer, AddDeleteReorderListWidget buttons, TsnConfiguration tsnConfig, CommandExecutor executor) {
        buttons.bindToTableViewer(windowViewer, executor, ref -> new CreateTsnWindowCommand(tsnConfig, 1), ref -> new DeleteTsnWindowCommand(tsnConfig, (TsnWindow)ref), ref -> new ChangeTsnWindowOrderCommand((TsnWindow)ref, tsnConfig, true), ref -> new ChangeTsnWindowOrderCommand((TsnWindow)ref, tsnConfig, false));
    }

    private static void configureTableLayout(Table table) {
        TableColumn column1 = new TableColumn(table, 16384);
        column1.setText(NAME_COL);
        TableColumn column2 = new TableColumn(table, 16384);
        column2.setText(VALUE_COL);
        TableColumn column3 = new TableColumn(table, 16384);
        column3.setText(TYPE_COL);
        TableColumn column4 = new TableColumn(table, 16384);
        column4.setText(COMMENT_COL);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 70));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, 70));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, 70));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 90));
        table.setLayout((Layout)layout);
    }

    public CommunicationConfiguration createModel() {
        return CommunicationFactory.eINSTANCE.createTsnConfiguration();
    }

    public CommunicationConfiguration createModel(List<VarDeclaration> parameters) {
        TsnConfiguration configuration = (TsnConfiguration)this.createModel();
        for (VarDeclaration parameter : parameters) {
            if (parameter.getName().startsWith("ChannelP")) {
                TsnWindow window = CommunicationFactory.eINSTANCE.createTsnWindow();
                window.setDuration(Integer.parseInt(parameter.getValue().getValue()));
                configuration.getWindows().add((Object)window);
                continue;
            }
            if (!parameter.getName().equals("CycleTime")) continue;
            configuration.setCycleTime(Integer.parseInt(parameter.getValue().getValue()));
        }
        int sum = configuration.getWindows().stream().mapToInt(TsnWindow::getDuration).sum();
        if (sum > configuration.getCycleTime()) {
            configuration.setCycleTime(sum);
        }
        return configuration;
    }

    private static class TimeSlotCellModifier
    implements ICellModifier {
        private final CommandExecutor executor;
        private final TableViewer viewer;

        public TimeSlotCellModifier(TableViewer windowViewer, CommandExecutor executor) {
            this.executor = executor;
            this.viewer = windowViewer;
        }

        public boolean canModify(Object element, String property) {
            return element instanceof TsnWindow && !TsnDetails.NAME_COL.equals(property) && !TsnDetails.TYPE_COL.equals(property);
        }

        public String getValue(Object element, String property) {
            return switch (property) {
                case TsnDetails.NAME_COL -> ((TsnWindow)element).getName();
                case TsnDetails.VALUE_COL -> String.valueOf(((TsnWindow)element).getDuration());
                case TsnDetails.TYPE_COL -> "TIME";
                case TsnDetails.COMMENT_COL -> ((TsnWindow)element).getComment();
                default -> null;
            };
        }

        public void modify(Object element, String property, Object value) {
            TsnWindow data = (TsnWindow)((TableItem)element).getData();
            Object cmd = null;
            switch (property) {
                case "value": {
                    cmd = new ChangeTsnWindowDurationCommand(data, Integer.parseInt(value.toString()));
                    break;
                }
                case "comment": {
                    cmd = new ChangeCommentCommand((INamedElement)data, value.toString());
                }
            }
            this.executor.executeCommand(cmd);
            this.viewer.refresh();
        }
    }
}

