/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.ui.actions.IOpenListener;
import org.eclipse.fordiac.ide.model.ui.actions.OpenListenerAction;
import org.eclipse.fordiac.ide.model.ui.editors.AbstractBreadCrumbEditor;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;

public abstract class OpenListener
implements IOpenListener {
    private IEditorPart editor = null;
    private static final String SUBAPP_TYPE_EDITOR = "org.eclipse.fordiac.ide.subapptypeeditor.SubAppTypeEditor";
    private static final String FB_TYPE_EDITOR = "org.eclipse.fordiac.ide.fbtypeeditor.editors.FBTypeEditor";

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    @Override
    public IEditorPart getOpenedEditor() {
        return this.editor;
    }

    @Override
    public final Action getOpenListenerAction() {
        return new OpenListenerAction(this);
    }

    protected void openEditor(IEditorInput input, String editorId) {
        this.editor = EditorUtils.openEditor((IEditorInput)input, (String)editorId);
    }

    protected void openInBreadCrumbEditor(IFile file, String editorId, EObject element) {
        this.openEditor((IEditorInput)new FileEditorInput(file), editorId);
        IEditorPart openedEditor = this.getOpenedEditor();
        if (openedEditor != null) {
            AbstractBreadCrumbEditor breadCrumbEditor = OpenListener.getBreadCrumbEditor(openedEditor);
            EObject elementToOpen = OpenListener.getElementToOpen(openedEditor, element);
            if (breadCrumbEditor != null && elementToOpen != null) {
                if (OpenListener.sameLevelAsParent(elementToOpen)) {
                    breadCrumbEditor.getBreadcrumb().setInput(elementToOpen.eContainer().eContainer());
                    HandlerHelper.selectElement((Object)elementToOpen, openedEditor);
                } else {
                    breadCrumbEditor.getBreadcrumb().setInput(elementToOpen);
                }
            }
        }
    }

    protected void openInSubappTypeEditor(SubAppType root, EObject element) {
        this.openInBreadCrumbEditor(root.getTypeEntry().getFile(), SUBAPP_TYPE_EDITOR, element);
    }

    protected void openInFBTypeEditor(FBType root, EObject element) {
        this.openInBreadCrumbEditor(root.getTypeEntry().getFile(), FB_TYPE_EDITOR, element);
    }

    public static AbstractBreadCrumbEditor getBreadCrumbEditor(IEditorPart openedEditor) {
        MultiPageEditorSite multiPageEditorSite;
        MultiPageEditorPart multiPageEditor;
        IEditorSite iEditorSite;
        AbstractBreadCrumbEditor breadCrumbEditor = (AbstractBreadCrumbEditor)((Object)openedEditor.getAdapter(AbstractBreadCrumbEditor.class));
        if (breadCrumbEditor != null && (iEditorSite = breadCrumbEditor.getEditorSite()) instanceof MultiPageEditorSite && (multiPageEditor = (multiPageEditorSite = (MultiPageEditorSite)iEditorSite).getMultiPageEditor()).getSelectedPage() != breadCrumbEditor) {
            multiPageEditor.setActiveEditor((IEditorPart)breadCrumbEditor);
        }
        return breadCrumbEditor;
    }

    private static boolean sameLevelAsParent(Object element) {
        return element instanceof Group;
    }

    public static EObject getElementToOpen(IEditorPart openedEditor, EObject element) {
        LibraryElement editorLibElement = (LibraryElement)openedEditor.getAdapter(LibraryElement.class);
        if (editorLibElement == null) {
            return null;
        }
        if (editorLibElement == EcoreUtil.getRootContainer((EObject)element)) {
            return element;
        }
        URI elementURI = EcoreUtil.getURI((EObject)element);
        return editorLibElement.eResource().getEObject(elementURI.fragment());
    }
}

