/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.tools;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fordiac.ide.gef.utilities.CollisionChangeBoundsRequest;
import org.eclipse.fordiac.ide.gef.utilities.TrackerMarginBoundsHelper;
import org.eclipse.fordiac.ide.model.ui.editors.AdvancedScrollingGraphicalViewer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.swt.events.MouseEvent;

public class ScrollingDragEditPartsTracker
extends DragEditPartsTracker {
    private final TrackerMarginBoundsHelper boundsHelper = new TrackerMarginBoundsHelper();

    public ScrollingDragEditPartsTracker(EditPart sourceEditPart) {
        super(sourceEditPart);
    }

    protected Request createTargetRequest() {
        if (this.isCloneActive()) {
            return new ChangeBoundsRequest((Object)"clone");
        }
        return new CollisionChangeBoundsRequest("move", this.boundsHelper.getFigures(), this.boundsHelper.getParentFigure());
    }

    public void mouseDrag(MouseEvent me, EditPartViewer viewer) {
        if (this.isActive() && viewer instanceof AdvancedScrollingGraphicalViewer) {
            AdvancedScrollingGraphicalViewer scrollingViewer = (AdvancedScrollingGraphicalViewer)viewer;
            Point oldViewPort = scrollingViewer.getViewLocation();
            ((AdvancedScrollingGraphicalViewer)viewer).checkScrollPositionDuringDrag(me);
            Dimension delta = oldViewPort.getDifference(scrollingViewer.getViewLocation());
            this.setStartLocation(this.getStartLocation().getTranslated(delta));
        }
        super.mouseDrag(me, viewer);
    }

    protected boolean handleDragStarted() {
        this.boundsHelper.initDrag(this.getSourceEditPart(), this.getCurrentViewer().getSelectedEditParts());
        return super.handleDragStarted();
    }

    protected void setCloneActive(boolean cloneActive) {
        super.setCloneActive(cloneActive);
        this.boundsHelper.createFigures(this.getTargetEditPart());
    }

    protected void eraseSourceFeedback() {
        this.boundsHelper.clearFigureList();
        super.eraseSourceFeedback();
    }

    protected void showSourceFeedback() {
        this.boundsHelper.createFigures(this.getTargetEditPart());
        super.showSourceFeedback();
    }
}

