/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.replaydebugging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.fordiac.ide.debug.replaydebugging.DataPointChange;
import org.eclipse.fordiac.ide.debug.replaydebugging.EventChange;

public class ReplayNavigator {
    private DatapointsState currentState = new DatapointsState();
    private final List<EventChange> eventChanges;
    private int currentEventNumber;
    private final Identifier identifier;
    private final HashMap<String, List<Integer>> datapointsChangedAt = new HashMap();
    private final List<StateListener> stateListeners = new ArrayList<StateListener>();

    public ReplayNavigator(Identifier identifier, DatapointsState initialState, List<EventChange> eventChanges) {
        this.identifier = identifier;
        this.currentState = initialState;
        this.eventChanges = eventChanges;
        this.currentEventNumber = 0;
        int i = 0;
        while (i < eventChanges.size()) {
            for (DataPointChange datapoint : eventChanges.get(i).newValues()) {
                List<Integer> indices = this.datapointsChangedAt.get(datapoint.datapoint());
                if (indices == null) {
                    indices = new ArrayList<Integer>();
                    this.datapointsChangedAt.put(datapoint.datapoint(), indices);
                }
                indices.add(i);
            }
            ++i;
        }
    }

    public void addStateChangeListener(StateListener stateListener) {
        this.stateListeners.add(stateListener);
    }

    public void removeStateChangeListener(StateListener stateListener) {
        this.stateListeners.remove(stateListener);
    }

    public EventChange getCurrentEventChange() {
        if (this.currentEventNumber <= 0 || this.currentEventNumber > this.eventChanges.size()) {
            return null;
        }
        return this.eventChanges.get(this.currentEventNumber - 1);
    }

    public int getAmountOfEvents() {
        return this.eventChanges.size();
    }

    public int getCurrentEventNumber() {
        return this.currentEventNumber;
    }

    public DatapointsState getCurrentState() {
        return this.currentState;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public List<Integer> getEventsThatTouch(String datapoint) {
        ArrayList touchedEvents = this.datapointsChangedAt.get(datapoint);
        return touchedEvents != null ? touchedEvents : new ArrayList();
    }

    public void moveOneEventForward() {
        this.moveToEvent(this.currentEventNumber + 1);
    }

    public void moveOneEventBackwards() {
        this.moveToEvent(this.currentEventNumber - 1);
    }

    public void moveToEvent(int eventNumber) {
        if (eventNumber < 0 || eventNumber > this.getAmountOfEvents()) {
            return;
        }
        DatapointsState changedValues = this.getChangesFromTo(this.currentEventNumber, eventNumber);
        this.currentEventNumber = eventNumber;
        this.updateCache(changedValues);
    }

    private DatapointsState getChangesFromTo(int initialEventNumber, int finalEventNumber) {
        if (initialEventNumber < finalEventNumber) {
            return this.getChangesFromToForward(initialEventNumber, finalEventNumber);
        }
        return this.getChangesFromToBackwards(initialEventNumber, finalEventNumber);
    }

    private DatapointsState getChangesFromToForward(int initialEventNumber, int finalEventNumber) {
        DatapointsState changedValues = new DatapointsState();
        int i = initialEventNumber + 1;
        while (i <= finalEventNumber) {
            EventChange eventChange = this.eventChanges.get(i - 1);
            for (DataPointChange dataPointChange : eventChange.newValues()) {
                String newValue = dataPointChange.newValue();
                changedValues.put(dataPointChange.datapoint(), newValue);
            }
            ++i;
        }
        return changedValues;
    }

    private DatapointsState getChangesFromToBackwards(int initialEventNumber, int finalEventNumber) {
        DatapointsState changedValues = new DatapointsState();
        int i = initialEventNumber;
        while (i >= finalEventNumber + 1) {
            EventChange eventChange = this.eventChanges.get(i - 1);
            for (DataPointChange dataPointChange : eventChange.newValues()) {
                String newValue = dataPointChange.oldValue();
                changedValues.put(dataPointChange.datapoint(), newValue);
            }
            --i;
        }
        return changedValues;
    }

    private void updateCache(DatapointsState changedValues) {
        this.currentState.putAll(changedValues);
        this.notifyStateChange(changedValues);
    }

    private void notifyStateChange(DatapointsState changedValues) {
        for (StateListener listener : this.stateListeners) {
            listener.update(this, changedValues);
        }
    }

    public static class DatapointsState
    extends HashMap<String, String> {
    }

    public record Identifier(String automationSystemName, String deviceName, String resourceName) {
    }

    public static interface StateListener {
        public void update(ReplayNavigator var1, DatapointsState var2);
    }
}

