/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editparts;

import java.util.function.Predicate;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.application.editparts.InstanceName;
import org.eclipse.fordiac.ide.application.figures.InstanceNameFigure;
import org.eclipse.fordiac.ide.gef.annotation.AnnotableGraphicalEditPart;
import org.eclipse.fordiac.ide.gef.annotation.FordiacAnnotationUtil;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModelEvent;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationStyles;
import org.eclipse.fordiac.ide.gef.editparts.LabelDirectEditManager;
import org.eclipse.fordiac.ide.gef.listeners.DiagramFontChangeListener;
import org.eclipse.fordiac.ide.gef.listeners.IFontUpdateListener;
import org.eclipse.fordiac.ide.gef.policies.AbstractViewRenameEditPolicy;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.ui.IEditorPart;

public class InstanceNameEditPart
extends AbstractGraphicalEditPart
implements NodeEditPart,
AnnotableGraphicalEditPart {
    private DiagramFontChangeListener fontChangeListener;
    private final Adapter contentAdapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            Object feature = notification.getFeature();
            if (LibraryElementPackage.eINSTANCE.getINamedElement_Name().equals(feature)) {
                InstanceNameEditPart.this.refreshValue();
            }
        }
    };

    public void activate() {
        super.activate();
        this.getModel().getRefElement().eAdapters().add((Object)this.contentAdapter);
        JFaceResources.getFontRegistry().addListener(this.getFontChangeListener());
    }

    public void deactivate() {
        super.deactivate();
        this.getModel().getRefElement().eAdapters().remove((Object)this.contentAdapter);
        JFaceResources.getFontRegistry().removeListener(this.getFontChangeListener());
    }

    private IPropertyChangeListener getFontChangeListener() {
        if (this.fontChangeListener == null) {
            this.fontChangeListener = new DiagramFontChangeListener((IFontUpdateListener)this.getFigure());
        }
        return this.fontChangeListener;
    }

    void refreshValue() {
        this.getFigure().setText(this.getModel().getInstanceName());
    }

    public void updateAnnotations(GraphicalAnnotationModelEvent event) {
        GraphicalAnnotationStyles.updateAnnotationFeedback((IFigure)this.getFigure(), (Object)this.getModel().getRefElement(), (GraphicalAnnotationModelEvent)event, (Predicate[])new Predicate[]{FordiacAnnotationUtil::showOnTargetName, FordiacAnnotationUtil::showOnTargetPosition});
    }

    public void refresh() {
        super.refresh();
        this.refreshValue();
    }

    public InstanceNameFigure getFigure() {
        return (InstanceNameFigure)super.getFigure();
    }

    protected void createEditPolicies() {
        this.removeEditPolicy("DirectEditPolicy");
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new AbstractViewRenameEditPolicy(){

            protected Command getDirectEditCommand(DirectEditRequest request) {
                GraphicalEditPart graphicalEditPart = this.getHost();
                if (graphicalEditPart instanceof InstanceNameEditPart) {
                    InstanceNameEditPart instanceNameEditPart = (InstanceNameEditPart)graphicalEditPart;
                    return ChangeNameCommand.forName((INamedElement)instanceNameEditPart.getModel().getRefElement(), (String)((String)request.getCellEditor().getValue()));
                }
                return null;
            }
        });
    }

    public InstanceName getModel() {
        return (InstanceName)super.getModel();
    }

    protected IFigure createFigure() {
        InstanceNameFigure figure = new InstanceNameFigure();
        if (this.isResoruceTypeFBNElement()) {
            figure.setIcon(FordiacImage.ICON_LOCKED_STATE.getImage());
        }
        return figure;
    }

    public void performRequest(Request request) {
        IEditorPart editor = EditorUtils.getCurrentActiveEditor();
        if (!(this.getModel().getRefElement().isContainedInTypedInstance() || editor.getAdapter(FBNetwork.class) == null || request.getType() != "direct edit" && request.getType() != "open")) {
            this.performDirectEdit();
        } else {
            super.performRequest(request);
        }
    }

    private DirectEditManager createDirectEditManager() {
        return new LabelDirectEditManager((GraphicalEditPart)this, (Label)this.getFigure());
    }

    private void performDirectEdit() {
        this.createDirectEditManager().show();
    }

    private boolean isResoruceTypeFBNElement() {
        FB fb;
        FBNetworkElement fBNetworkElement = this.getModel().getRefElement();
        return fBNetworkElement instanceof FB && (fb = (FB)fBNetworkElement).isResourceTypeFB();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return null;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return null;
    }
}

