/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.gef.utilities.ElementSelector;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.commands.QualNameAffectedCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.commands.change.MapToCommand;
import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.AdapterConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.DataConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.EventConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteFBNetworkElementCommand;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterConnection;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.EventConnection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.MappingTarget;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class FlattenSubAppCommand
extends Command
implements QualNameAffectedCommand {
    private final SubApp subapp;
    private final FBNetwork parentNetwork;
    private final List<FBNetworkElement> elements = new ArrayList<FBNetworkElement>();
    private final List<FBNetworkElement> elementsToMove = new ArrayList<FBNetworkElement>();
    private final List<EventConnection> transferEventConnections = new ArrayList<EventConnection>();
    private final List<DataConnection> transferDataConnections = new ArrayList<DataConnection>();
    private final List<AdapterConnection> transferAdapterConnections = new ArrayList<AdapterConnection>();
    private final CompoundCommand deleteCommands = new CompoundCommand();
    private final CompoundCommand createCommands = new CompoundCommand();
    private final CompoundCommand mapCommands = new CompoundCommand();
    private final CompoundCommand setUniqueName = new CompoundCommand();
    private final Position fbnetworkPosInSubapp;
    private boolean select = true;
    private final Map<INamedElement, String> oldQualNames = new HashMap<INamedElement, String>();
    private final Map<INamedElement, String> newQualNames = new HashMap<INamedElement, String>();

    public FlattenSubAppCommand(SubApp subapp) {
        super(Messages.FlattenSubAppCommand_LABEL_FlattenSubAppCommand);
        this.subapp = Objects.requireNonNull(subapp);
        this.parentNetwork = Objects.requireNonNull(subapp.getFbNetwork());
        this.fbnetworkPosInSubapp = FBNetworkHelper.getTopLeftCornerOfFBNetwork((List)subapp.getSubAppNetwork().getNetworkElements());
    }

    public FlattenSubAppCommand(SubApp subapp, boolean select) {
        this(subapp);
        this.select = select;
    }

    public void execute() {
        this.elements.addAll((Collection<FBNetworkElement>)this.subapp.getSubAppNetwork().getNetworkElements());
        this.elements.forEach(e -> {
            String string = this.oldQualNames.put((INamedElement)e, e.getQualifiedName());
        });
        this.elementsToMove.addAll(this.elements.stream().filter(el -> !el.isInGroup()).toList());
        FBNetworkHelper.moveFBNetworkByOffset(this.elementsToMove, (double)(-this.getOriginalPositionX()), (double)(-this.getOriginalPositionY()));
        this.checkConnections();
        this.createMapCommands();
        this.deleteCommands.add((Command)new DeleteFBNetworkElementCommand((FBNetworkElement)this.subapp));
        this.deleteCommands.execute();
        this.subapp.getSubAppNetwork().getNetworkElements().removeAll(this.elements);
        this.parentNetwork.getNetworkElements().addAll(this.elements);
        this.subapp.getSubAppNetwork().getEventConnections().removeAll(this.transferEventConnections);
        this.parentNetwork.getEventConnections().addAll(this.transferEventConnections);
        this.subapp.getSubAppNetwork().getDataConnections().removeAll(this.transferDataConnections);
        this.parentNetwork.getDataConnections().addAll(this.transferDataConnections);
        this.subapp.getSubAppNetwork().getAdapterConnections().removeAll(this.transferAdapterConnections);
        this.parentNetwork.getAdapterConnections().addAll(this.transferAdapterConnections);
        this.createCommands.execute();
        this.mapCommands.execute();
        for (FBNetworkElement fbNetworkElement : this.elements) {
            this.ensureUniqueName(fbNetworkElement);
        }
        if (this.select) {
            ElementSelector.selectViewObjects(this.elementsToMove);
        }
        this.elements.forEach(e -> {
            String string = this.newQualNames.put((INamedElement)e, e.getQualifiedName());
        });
    }

    private void ensureUniqueName(FBNetworkElement element) {
        if (!NameRepository.isValidName((INamedElement)element, (String)element.getName())) {
            String uniqueName = NameRepository.createUniqueName((INamedElement)element, (String)element.getName());
            ChangeNameCommand uniqueNameCmd = ChangeNameCommand.forName((INamedElement)element, (String)uniqueName);
            uniqueNameCmd.execute();
            this.setUniqueName.add((Command)uniqueNameCmd);
        }
    }

    public void redo() {
        this.deleteCommands.redo();
        this.subapp.getSubAppNetwork().getNetworkElements().removeAll(this.elements);
        this.parentNetwork.getNetworkElements().addAll(this.elements);
        FBNetworkHelper.moveFBNetworkByOffset(this.elementsToMove, (double)(-this.getOriginalPositionX()), (double)(-this.getOriginalPositionY()));
        this.subapp.getSubAppNetwork().getEventConnections().removeAll(this.transferEventConnections);
        this.parentNetwork.getEventConnections().addAll(this.transferEventConnections);
        this.subapp.getSubAppNetwork().getDataConnections().removeAll(this.transferDataConnections);
        this.parentNetwork.getDataConnections().addAll(this.transferDataConnections);
        this.subapp.getSubAppNetwork().getAdapterConnections().removeAll(this.transferAdapterConnections);
        this.parentNetwork.getAdapterConnections().addAll(this.transferAdapterConnections);
        this.createCommands.redo();
        this.setUniqueName.redo();
        this.mapCommands.redo();
        if (this.select) {
            ElementSelector.selectViewObjects(this.elementsToMove);
        }
    }

    public void undo() {
        this.mapCommands.undo();
        this.createCommands.undo();
        this.parentNetwork.getNetworkElements().removeAll(this.elements);
        this.subapp.getSubAppNetwork().getNetworkElements().addAll(this.elements);
        FBNetworkHelper.moveFBNetworkByOffset(this.elementsToMove, (double)this.getOriginalPositionX(), (double)this.getOriginalPositionY());
        this.parentNetwork.getEventConnections().removeAll(this.transferEventConnections);
        this.subapp.getSubAppNetwork().getEventConnections().addAll(this.transferEventConnections);
        this.parentNetwork.getDataConnections().removeAll(this.transferDataConnections);
        this.subapp.getSubAppNetwork().getDataConnections().addAll(this.transferDataConnections);
        this.parentNetwork.getAdapterConnections().removeAll(this.transferAdapterConnections);
        this.subapp.getSubAppNetwork().getAdapterConnections().addAll(this.transferAdapterConnections);
        this.setUniqueName.undo();
        this.deleteCommands.undo();
        if (this.select) {
            ElementSelector.selectViewObjects(Arrays.asList(this.subapp));
        }
    }

    private void checkConnections() {
        this.checkConnectionList((List)this.subapp.getSubAppNetwork().getEventConnections(), (List)this.transferEventConnections);
        this.checkConnectionList((List)this.subapp.getSubAppNetwork().getDataConnections(), (List)this.transferDataConnections);
        this.checkConnectionList((List)this.subapp.getSubAppNetwork().getAdapterConnections(), (List)this.transferAdapterConnections);
    }

    private double getOriginalPositionX() {
        return -this.subapp.getPosition().getX() + this.fbnetworkPosInSubapp.getX();
    }

    private double getOriginalPositionY() {
        return -this.subapp.getPosition().getY() + this.fbnetworkPosInSubapp.getY();
    }

    private void createMapCommands() {
        if (this.subapp.isMapped()) {
            for (FBNetworkElement fbNetworkElement : this.elements) {
                this.mapCommands.add(MapToCommand.createMapToCommand((FBNetworkElement)fbNetworkElement, (MappingTarget)this.subapp.getResource()));
            }
        }
    }

    private <T extends Connection> void checkConnectionList(List<T> connectionList, List<T> transferConnectionList) {
        for (Connection connection : connectionList) {
            if (connection.getSourceElement() != this.subapp && connection.getDestinationElement() != this.subapp) {
                transferConnectionList.add(connection);
                continue;
            }
            this.deleteCommands.add((Command)new DeleteConnectionCommand(connection));
            this.createCommandsFrom(connection);
        }
    }

    private <T extends Connection> void createCommandsFrom(T connection) {
        block5: {
            block6: {
                block4: {
                    if (connection.getSourceElement() != this.subapp || connection.getDestinationElement() != this.subapp) break block4;
                    for (Connection inboundConn : connection.getSource().getInputConnections()) {
                        for (Connection outboundConn : connection.getDestination().getOutputConnections()) {
                            this.createCommands.add((Command)this.createConnCreateCmd(inboundConn.getSource(), outboundConn.getDestination()));
                        }
                    }
                    break block5;
                }
                if (connection.getSourceElement() != this.subapp) break block6;
                for (Connection inboundConn : connection.getSource().getInputConnections()) {
                    this.createCommands.add((Command)this.createConnCreateCmd(inboundConn.getSource(), connection.getDestination()));
                }
                break block5;
            }
            if (connection.getDestinationElement() != this.subapp) break block5;
            for (Connection outboundConn : connection.getDestination().getOutputConnections()) {
                this.createCommands.add((Command)this.createConnCreateCmd(connection.getSource(), outboundConn.getDestination()));
            }
        }
    }

    private AbstractConnectionCreateCommand createConnCreateCmd(IInterfaceElement source, IInterfaceElement destination) {
        EventConnectionCreateCommand cmd = null;
        if (source instanceof Event) {
            cmd = new EventConnectionCreateCommand(this.parentNetwork);
        } else if (source instanceof AdapterDeclaration) {
            cmd = new AdapterConnectionCreateCommand(this.parentNetwork);
        } else if (source instanceof VarDeclaration) {
            cmd = new DataConnectionCreateCommand(this.parentNetwork);
        }
        if (cmd != null) {
            cmd.setSource(source);
            cmd.setDestination(destination);
        }
        return cmd;
    }

    public Set<EObject> getAffectedObjects() {
        return Set.of(this.parentNetwork);
    }

    public String getOldQualName(INamedElement element) {
        return this.oldQualNames.get(element);
    }

    public String getNewQualName(INamedElement element) {
        return this.newQualNames.get(element);
    }

    public List<INamedElement> getChangedElements() {
        return new ArrayList<FBNetworkElement>(this.elements);
    }
}

