/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.library;

import java.util.List;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.widgets.LabelFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class InstanceUpdateDialog
extends MessageDialog {
    protected static final int TABLE_COL_WIDTH = 300;
    private final List<FBNetworkElement> updatedInstances;

    public InstanceUpdateDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, List<FBNetworkElement> updatedInstances) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.updatedInstances = updatedInstances;
    }

    protected Control createCustomArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite searchResArea = (Composite)WidgetFactory.composite((int)0).create((Widget)parent);
        searchResArea.setLayout((Layout)new GridLayout(1, true));
        searchResArea.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.updatedInstances.isEmpty()) {
            Label warningLabel = (Label)LabelFactory.newLabel((int)0).create((Widget)searchResArea);
            warningLabel.setText("No instances have been updated!");
        } else {
            TreeViewer treeViewer = new TreeViewer(searchResArea);
            this.configureTableViewer(treeViewer);
            treeViewer.setInput((Object)this.updatedInstances.toArray());
            GridLayoutFactory.fillDefaults().generateLayout(searchResArea);
        }
        return parent;
    }

    protected void configureTableViewer(TreeViewer viewer) {
        viewer.setContentProvider((IContentProvider)new InstanceUpdateContentProvider());
        viewer.getTree().setHeaderVisible(true);
        viewer.getTree().setLinesVisible(true);
        viewer.getTree().setLayout((Layout)this.createTableLayout());
        TreeViewerColumn colType = new TreeViewerColumn(viewer, 16384);
        colType.getColumn().setText(FordiacMessages.InstanceName);
        colType.setLabelProvider((CellLabelProvider)InstanceUpdateDialog.createLabelProvider());
    }

    protected TableLayout createTableLayout() {
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(300));
        return layout;
    }

    private static ColumnLabelProvider createLabelProvider() {
        return new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof FBNetworkElement) {
                    FBNetworkElement fbnElem = (FBNetworkElement)element;
                    return fbnElem.getName();
                }
                return super.getText(element);
            }
        };
    }

    private class InstanceUpdateContentProvider
    implements ITreeContentProvider {
        private InstanceUpdateContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Object[]) {
                return (Object[])inputElement;
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }
}

