/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable.primitive;

import aQute.bnd.annotation.spi.ServiceProvider;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.factory.list.primitive.ImmutableFloatListFactory;
import org.eclipse.collections.api.list.primitive.ImmutableFloatList;
import org.eclipse.collections.impl.factory.primitive.FloatLists;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableFloatArrayList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableFloatEmptyList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableFloatSingletonList;

@ServiceProvider(value=ImmutableFloatListFactory.class)
public class ImmutableFloatListFactoryImpl
implements ImmutableFloatListFactory {
    public static final ImmutableFloatListFactory INSTANCE = new ImmutableFloatListFactoryImpl();

    public ImmutableFloatList empty() {
        return ImmutableFloatEmptyList.INSTANCE;
    }

    public ImmutableFloatList of() {
        return this.empty();
    }

    public ImmutableFloatList with() {
        return this.empty();
    }

    public ImmutableFloatList of(float one) {
        return this.with(one);
    }

    public ImmutableFloatList with(float one) {
        return new ImmutableFloatSingletonList(one);
    }

    public ImmutableFloatList of(float ... items) {
        return this.with(items);
    }

    public ImmutableFloatList with(float ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableFloatArrayList.newListWith(items);
    }

    public ImmutableFloatList ofAll(FloatIterable items) {
        return this.withAll(items);
    }

    public ImmutableFloatList withAll(FloatIterable items) {
        if (items instanceof ImmutableFloatList) {
            return (ImmutableFloatList)items;
        }
        if (items == null || items.size() == 0) {
            return this.with();
        }
        if (items.size() == 1) {
            return this.with(items.toArray()[0]);
        }
        return ImmutableFloatArrayList.newList(items);
    }

    public ImmutableFloatList ofAll(Iterable<Float> iterable) {
        return this.withAll(iterable);
    }

    public ImmutableFloatList withAll(Iterable<Float> iterable) {
        return FloatLists.mutable.withAll(iterable).toImmutable();
    }
}

