/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands;

import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceTransaction;
import org.eclipse.gef.commands.Command;

public class MoveTransactionCommand
extends Command {
    private final ServiceSequence parent;
    private final ServiceTransaction moveElement;
    private final int oldIndex;
    private final int newIndex;

    public MoveTransactionCommand(ServiceTransaction model, int oldIndex, int newIndex) {
        this.moveElement = model;
        this.oldIndex = oldIndex;
        this.newIndex = newIndex;
        this.parent = this.moveElement.getServiceSequence();
    }

    public boolean canExecute() {
        return this.parent != null && this.moveElement != null;
    }

    public void execute() {
        this.moveToIndex(this.newIndex);
    }

    public void undo() {
        this.moveToIndex(this.oldIndex);
    }

    public void redo() {
        this.moveToIndex(this.newIndex);
    }

    private void moveToIndex(int index) {
        this.parent.getServiceTransaction().move(index, (Object)this.moveElement);
    }
}

