/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editparts;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.application.editparts.IContainerEditPart;
import org.eclipse.fordiac.ide.application.editparts.InstanceComment;
import org.eclipse.fordiac.ide.application.editparts.InstanceCommentEditPart;
import org.eclipse.fordiac.ide.application.figures.InstanceCommentFigure;
import org.eclipse.fordiac.ide.application.policies.AbstractCreateInstanceDirectEditPolicy;
import org.eclipse.fordiac.ide.application.policies.FBNetworkCreateInstanceDirectEditPolicy;
import org.eclipse.fordiac.ide.gef.draw2d.SingleLineBorder;
import org.eclipse.fordiac.ide.gef.editparts.AbstractFBNetworkEditPart;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.ui.editors.AdvancedScrollingGraphicalViewer;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;

public abstract class EditorWithInterfaceEditPart
extends AbstractFBNetworkEditPart {
    public static final Color INTERFACE_BAR_BG_COLOR = new Color(235, 245, 255);
    public static final Color INTERFACE_BAR_BORDER_COLOR = new Color(190, 199, 225);
    private static final int TOP_BOTTOM_MARGIN = 1;
    private static final int LEFT_RIGHT_MARGIN = 5;
    private static final Insets RIGHT_LIST_BORDER_INSET = new Insets(1, 0, 1, 5);
    private static final Insets LEFT_LIST_BORDER_INSET = new Insets(1, 5, 1, 0);
    private static final int BASE_WIDTH = 400;
    private static final int BASE_HEIGHT = 200;
    private Figure leftInterfaceContainer;
    private Figure leftEventContainer;
    private Figure leftVarContainer;
    private Figure leftVarInOutContainer;
    private Figure leftAdapterContainer;
    private Figure rightInterfaceContainer;
    private Figure rightEventContainer;
    private Figure rightVarContainer;
    private Figure rightVarInOutContainer;
    private Figure rightAdapterContainer;
    private FreeformLayer contentContainer;
    private ControlListener controlListener;
    private InstanceComment instanceComment;
    private Figure commentContainer;
    private final Adapter contentAdapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            switch (notification.getEventType()) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    EditorWithInterfaceEditPart.this.refreshChildren();
                    break;
                }
                case 1: {
                    EditorWithInterfaceEditPart.this.refreshVisuals();
                    break;
                }
            }
        }
    };
    private final Adapter interfaceAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            switch (notification.getEventType()) {
                case 3: {
                    if (LibraryElementPackage.eINSTANCE.getConfigurableObject_Attributes().equals(notification.getFeature())) {
                        EditorWithInterfaceEditPart.this.refreshVisuals();
                        break;
                    }
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    EditorWithInterfaceEditPart.this.refreshChildren();
                    break;
                }
            }
        }
    };

    public void activate() {
        super.activate();
        if (this.getModel() != null && !this.getModel().eAdapters().contains((Object)this.contentAdapter)) {
            this.getModel().eAdapters().add((Object)this.contentAdapter);
            if (this.getInterfaceList() != null && !this.getInterfaceList().eAdapters().contains((Object)this.interfaceAdapter)) {
                this.getInterfaceList().eAdapters().add((Object)this.interfaceAdapter);
            }
        }
    }

    public void deactivate() {
        super.deactivate();
        if (this.getModel() != null) {
            this.getModel().eAdapters().remove((Object)this.contentAdapter);
            if (this.getInterfaceList() != null) {
                this.getInterfaceList().eAdapters().remove((Object)this.interfaceAdapter);
            }
        }
        if (this.controlListener != null && this.getParent() != null && this.getParent().getViewer() != null && this.getParent().getViewer().getControl() != null) {
            this.getParent().getViewer().getControl().removeControlListener(this.controlListener);
        }
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new FBNetworkCreateInstanceDirectEditPolicy());
    }

    protected IFigure createFigure() {
        Figure mainFigure = new Figure();
        InterfaceBarLayout mainLayout = new InterfaceBarLayout();
        mainLayout.setVerticalSpacing(-1);
        mainFigure.setLayoutManager((LayoutManager)mainLayout);
        mainFigure.setOpaque(false);
        this.createLeftInterface((IFigure)mainFigure);
        this.contentContainer = new FreeformLayer();
        this.contentContainer.setLayoutManager((LayoutManager)new FreeformLayout());
        this.contentContainer.setBorder((Border)new MarginBorder(0, this.getMaxHiddenConnectionLabelSize(), 0, this.getMaxHiddenConnectionLabelSize()));
        mainFigure.add((IFigure)this.contentContainer, (Object)BorderLayout.CENTER);
        this.createRightInterface((IFigure)mainFigure);
        this.createCommentContainer((IFigure)mainFigure);
        IFigure root = super.createFigure();
        root.setBorder(null);
        root.add((IFigure)mainFigure);
        root.setConstraint((IFigure)mainFigure, (Object)new Rectangle(0, 0, -1, -1));
        return root;
    }

    private void createLeftInterface(IFigure mainFigure) {
        this.leftInterfaceContainer = EditorWithInterfaceEditPart.createRootContainer(mainFigure, BorderLayout.LEFT);
        Figure leftInnerContainer = this.createInnerContainer((IFigure)this.leftInterfaceContainer, LEFT_LIST_BORDER_INSET);
        EditorWithInterfaceEditPart.configureLeftContainer(leftInnerContainer);
        this.leftEventContainer = EditorWithInterfaceEditPart.createInterfaceElementsContainer((IFigure)leftInnerContainer);
        EditorWithInterfaceEditPart.configureLeftContainer(this.leftEventContainer);
        this.leftVarContainer = EditorWithInterfaceEditPart.createInterfaceElementsContainer((IFigure)leftInnerContainer);
        EditorWithInterfaceEditPart.configureLeftContainer(this.leftVarContainer);
        this.leftVarInOutContainer = EditorWithInterfaceEditPart.createInterfaceElementsContainer((IFigure)leftInnerContainer);
        EditorWithInterfaceEditPart.configureLeftContainer(this.leftVarInOutContainer);
        this.leftAdapterContainer = EditorWithInterfaceEditPart.createInterfaceElementsContainer((IFigure)leftInnerContainer);
        EditorWithInterfaceEditPart.configureLeftContainer(this.leftAdapterContainer);
    }

    private void createRightInterface(IFigure mainFigure) {
        this.rightInterfaceContainer = EditorWithInterfaceEditPart.createRootContainer(mainFigure, BorderLayout.RIGHT);
        Figure rightInnerContainer = this.createInnerContainer((IFigure)this.rightInterfaceContainer, RIGHT_LIST_BORDER_INSET);
        this.rightEventContainer = EditorWithInterfaceEditPart.createInterfaceElementsContainer((IFigure)rightInnerContainer);
        this.rightVarContainer = EditorWithInterfaceEditPart.createInterfaceElementsContainer((IFigure)rightInnerContainer);
        this.rightVarInOutContainer = EditorWithInterfaceEditPart.createInterfaceElementsContainer((IFigure)rightInnerContainer);
        this.rightAdapterContainer = EditorWithInterfaceEditPart.createInterfaceElementsContainer((IFigure)rightInnerContainer);
    }

    private static Figure createRootContainer(IFigure parent, Integer layoutConstraint) {
        RectangleFigure rootContainer = new RectangleFigure();
        GridLayout rootContLayout = new GridLayout(1, false);
        rootContLayout.marginHeight = EditorWithInterfaceEditPart.getInterfaceBarTopPadding();
        rootContLayout.marginWidth = 0;
        rootContainer.setLayoutManager((LayoutManager)rootContLayout);
        rootContainer.setOpaque(true);
        rootContainer.setOutline(false);
        rootContainer.setBackgroundColor(INTERFACE_BAR_BG_COLOR);
        rootContainer.setBorder((Border)new SingleLineBorder(INTERFACE_BAR_BORDER_COLOR));
        parent.add((IFigure)rootContainer, (Object)layoutConstraint);
        return rootContainer;
    }

    public static int getInterfaceBarTopPadding() {
        return (int)(CoordinateConverter.INSTANCE.getLineHeight() * 1.75);
    }

    private static void configureLeftContainer(Figure container) {
        ((ToolbarLayout)container.getLayoutManager()).setMinorAlignment(2);
    }

    private Figure createInnerContainer(IFigure parent, Insets borderInset) {
        MinSizeFigure innerContainer = new MinSizeFigure();
        innerContainer.setMinimumSize(new Dimension(this.getMinInterfaceBarWidth(), -1));
        ToolbarLayout innerLayout = new ToolbarLayout(false);
        innerContainer.setLayoutManager((LayoutManager)innerLayout);
        innerContainer.setBorder((Border)new MarginBorder(borderInset));
        parent.add((IFigure)innerContainer);
        return innerContainer;
    }

    private static Figure createInterfaceElementsContainer(IFigure parent) {
        Figure container = new Figure();
        container.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        parent.add((IFigure)container);
        return container;
    }

    private void createCommentContainer(IFigure mainFigure) {
        this.commentContainer = new Figure();
        SingleLineBorder border = new SingleLineBorder(){
            private final Insets insets = new Insets(5);

            public Insets getInsets(IFigure figure) {
                return this.insets;
            }
        };
        this.commentContainer.setBorder((Border)border);
        ToolbarLayout layout = new ToolbarLayout();
        layout.setMinorAlignment(0);
        layout.setStretchMinorAxis(false);
        this.commentContainer.setOpaque(true);
        this.commentContainer.setLayoutManager((LayoutManager)layout);
        mainFigure.add((IFigure)this.commentContainer, (Object)BorderLayout.TOP);
    }

    public Figure getLeftInterfaceContainer() {
        return this.leftInterfaceContainer;
    }

    public Figure getLeftEventInterfaceContainer() {
        return this.leftEventContainer;
    }

    public Figure getLeftVarInterfaceContainer() {
        return this.leftVarContainer;
    }

    public Figure getLeftVarInOutInterfaceContainer() {
        return this.leftVarInOutContainer;
    }

    public Figure getLeftAdapterInterfaceContainer() {
        return this.leftAdapterContainer;
    }

    public Figure getRightInterfaceContainer() {
        return this.rightInterfaceContainer;
    }

    public Figure getRightEventInterfaceContainer() {
        return this.rightEventContainer;
    }

    public Figure getRightVarInterfaceContainer() {
        return this.rightVarContainer;
    }

    public Figure getRightVarInOutInterfaceContainer() {
        return this.rightVarInOutContainer;
    }

    public Figure getRightAdapterInterfaceContainer() {
        return this.rightAdapterContainer;
    }

    public FreeformLayer getContentPane() {
        return this.contentContainer;
    }

    protected abstract InterfaceList getInterfaceList();

    protected List<?> getModelChildren() {
        if (this.getModel() != null) {
            InstanceComment comment;
            ArrayList<InstanceComment> children = new ArrayList<InstanceComment>(super.getModelChildren());
            InterfaceList ifList = this.getInterfaceList();
            children.addAll((Collection<InstanceComment>)ifList.getEventInputs());
            children.addAll((Collection<InstanceComment>)ifList.getEventOutputs());
            children.addAll((Collection<InstanceComment>)ifList.getInputVars());
            children.addAll((Collection<InstanceComment>)ifList.getOutputVars());
            if (this.showAdapterPorts()) {
                children.addAll((Collection<InstanceComment>)ifList.getPlugs());
                children.addAll((Collection<InstanceComment>)ifList.getSockets());
            }
            if ((comment = this.getInstanceComment()) != null) {
                children.add(comment);
            }
            return children;
        }
        return Collections.emptyList();
    }

    private InstanceComment getInstanceComment() {
        EObject eObject;
        if (this.instanceComment == null && (eObject = this.getModel().eContainer()) instanceof INamedElement) {
            INamedElement namedEl = (INamedElement)eObject;
            this.instanceComment = new InstanceComment(namedEl);
        }
        return this.instanceComment;
    }

    private boolean showAdapterPorts() {
        return !(this.getModel().eContainer() instanceof CompositeFBType) || this.getModel().eContainer() instanceof SubAppType;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        EditPart editPart = childEditPart;
        Objects.requireNonNull(editPart);
        EditPart editPart2 = editPart;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InterfaceEditPart.class, InstanceCommentEditPart.class}, (Object)editPart2, 0)) {
            case 0: {
                InterfaceEditPart iep = (InterfaceEditPart)editPart2;
                this.addChildVisualInterfaceElement(iep);
                break;
            }
            case 1: {
                InstanceCommentEditPart icep = (InstanceCommentEditPart)editPart2;
                InstanceCommentFigure commentFigure = icep.getFigure();
                commentFigure.setBorder(null);
                this.commentContainer.add((IFigure)commentFigure);
                break;
            }
            default: {
                super.addChildVisual(childEditPart, index);
            }
        }
    }

    protected void removeChildVisual(EditPart childEditPart) {
        EditPart editPart = childEditPart;
        Objects.requireNonNull(editPart);
        EditPart editPart2 = editPart;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InterfaceEditPart.class, InstanceCommentEditPart.class}, (Object)editPart2, 0)) {
            case 0: {
                InterfaceEditPart iep = (InterfaceEditPart)editPart2;
                this.removeChildVisualInterfaceElement(iep);
                break;
            }
            case 1: {
                InstanceCommentEditPart icep = (InstanceCommentEditPart)editPart2;
                this.commentContainer.remove((IFigure)icep.getFigure());
                break;
            }
            default: {
                super.removeChildVisual(childEditPart);
            }
        }
    }

    public void removeChildVisualInterfaceElement(InterfaceEditPart childEditPart) {
        IFigure child = childEditPart.getFigure().getParent();
        Figure container = this.getChildVisualContainer(childEditPart);
        if (child.getParent() == container) {
            container.remove(child);
        } else if (childEditPart.getModel() instanceof VarDeclaration) {
            if (child.getParent() == this.getLeftVarInOutInterfaceContainer()) {
                this.getLeftVarInOutInterfaceContainer().remove(child);
            } else {
                this.getRightVarInOutInterfaceContainer().remove(child);
            }
        } else {
            this.getContentPane().remove(child);
        }
    }

    protected Figure getChildVisualContainer(InterfaceEditPart childEditPart) {
        if (childEditPart.isEvent()) {
            return this.getEventVisualContainer(childEditPart);
        }
        if (childEditPart.isAdapter()) {
            return this.getAdapterVisualContainer(childEditPart);
        }
        return this.getVarVisualContainer(childEditPart);
    }

    private Figure getVarVisualContainer(InterfaceEditPart childEditPart) {
        VarDeclaration varDecl;
        IInterfaceElement model = childEditPart.getModel();
        if (model instanceof VarDeclaration && (varDecl = (VarDeclaration)model).isInOutVar()) {
            return model.isIsInput() ? this.getLeftVarInOutInterfaceContainer() : this.getRightVarInOutInterfaceContainer();
        }
        return model.isIsInput() ? this.getLeftVarInterfaceContainer() : this.getRightVarInterfaceContainer();
    }

    private Figure getAdapterVisualContainer(InterfaceEditPart childEditPart) {
        return childEditPart.getModel().isIsInput() ? this.getLeftAdapterVisualContainer() : this.getRighAdapterVisualContainer();
    }

    private Figure getEventVisualContainer(InterfaceEditPart childEditPart) {
        return childEditPart.getModel().isIsInput() ? this.getLeftEventInterfaceContainer() : this.getRightEventInterfaceContainer();
    }

    private Figure getLeftAdapterVisualContainer() {
        return this.showAdapterPorts() ? this.getLeftAdapterInterfaceContainer() : this.getLeftInterfaceContainer();
    }

    private Figure getRighAdapterVisualContainer() {
        return this.showAdapterPorts() ? this.getRightAdapterInterfaceContainer() : this.getRightInterfaceContainer();
    }

    public void addChildVisualInterfaceElement(InterfaceEditPart childEditPart) {
        IFigure child = childEditPart.getFigure();
        Figure targetFigure = this.getChildVisualContainer(childEditPart);
        int index = this.getIEIndex(childEditPart);
        int containerSize = targetFigure.getChildren().size();
        targetFigure.add(EditorWithInterfaceEditPart.createSideBarFigure(childEditPart), index >= containerSize ? containerSize : index);
        child.setVisible(this.isVarVisible((EditPart)childEditPart));
    }

    private int getIEIndex(InterfaceEditPart childEditPart) {
        VarDeclaration varDecl;
        IInterfaceElement model = childEditPart.getModel();
        InterfaceList ifList = this.getInterfaceList();
        if (childEditPart.isEvent()) {
            return model.isIsInput() ? ifList.getEventInputs().indexOf((Object)model) : ifList.getEventOutputs().indexOf((Object)model);
        }
        if (childEditPart.isAdapter()) {
            return model.isIsInput() ? ifList.getSockets().indexOf((Object)model) : ifList.getPlugs().indexOf((Object)model);
        }
        if (model instanceof VarDeclaration && (varDecl = (VarDeclaration)model).isInOutVar()) {
            return ifList.getInOutVars().indexOf((Object)varDecl);
        }
        return model.isIsInput() ? ifList.getInputVars().indexOf((Object)model) : ifList.getOutputVars().indexOf((Object)model);
    }

    private static IFigure createSideBarFigure(InterfaceEditPart ep) {
        Figure container = new Figure();
        container.setLayoutManager((LayoutManager)new ToolbarLayout());
        int yPositionFromAttribute = EditorWithInterfaceEditPart.getYPositionFromAttribute(ep.getModel());
        MinSizeFigure paddingFigure = new MinSizeFigure();
        paddingFigure.setMinimumSize(new Dimension(-1, yPositionFromAttribute));
        container.add((IFigure)paddingFigure);
        container.add(ep.getFigure());
        return container;
    }

    private static int getYPositionFromAttribute(IInterfaceElement ie) {
        Attribute attribute = ie.getAttribute("YPOSITION");
        if (attribute != null) {
            return Integer.parseInt(attribute.getValue());
        }
        return 0;
    }

    protected boolean isVarVisible(EditPart childEditPart) {
        return true;
    }

    public void performRequest(Request request) {
        if ((request.getType() == "direct edit" || request.getType() == "open") && request instanceof SelectionRequest) {
            SelectionRequest selReq = (SelectionRequest)request;
            EditPolicy editPolicy = this.getEditPolicy("DirectEditPolicy");
            if (editPolicy instanceof AbstractCreateInstanceDirectEditPolicy) {
                AbstractCreateInstanceDirectEditPolicy createInstanceDEP = (AbstractCreateInstanceDirectEditPolicy)editPolicy;
                createInstanceDEP.performDirectEdit(selReq);
            }
        } else {
            super.performRequest(request);
        }
    }

    public DragTracker getDragTracker(Request req) {
        return this.getParent().getDragTracker(req);
    }

    public void refresh() {
        super.refresh();
        this.getChildren().stream().filter(IContainerEditPart.class::isInstance).map(IContainerEditPart.class::cast).forEach(container -> {
            container.refresh();
            GraphicalEditPart contentEP = container.getContentEP();
            if (contentEP != null) {
                contentEP.refresh();
            }
        });
    }

    public int getMinInterfaceBarWidth() {
        return ((AdvancedScrollingGraphicalViewer)this.getViewer()).getPreferencesCache().getMinInterfaceBarSize();
    }

    public int getMaxHiddenConnectionLabelSize() {
        return ((AdvancedScrollingGraphicalViewer)this.getViewer()).getPreferencesCache().getMaxHiddenConnectionLabelSize();
    }

    private class InterfaceBarLayout
    extends BorderLayout {
        private InterfaceBarLayout() {
        }

        protected Dimension calculatePreferredSize(IFigure figure, int wHint, int hHint) {
            Rectangle newBounds = new Rectangle();
            newBounds.setSize(super.calculatePreferredSize(figure, wHint, hHint));
            newBounds.setLocation(EditorWithInterfaceEditPart.this.getContentPane().getFreeformExtent().getLocation());
            newBounds.x -= EditorWithInterfaceEditPart.this.leftInterfaceContainer.getPreferredSize().width;
            newBounds.y -= EditorWithInterfaceEditPart.this.commentContainer.getPreferredSize().height;
            if (newBounds.x > 0) {
                newBounds.x = 0;
            }
            if (newBounds.y > 0) {
                newBounds.y = 0;
            }
            FreeformLayer layer = (FreeformLayer)EditorWithInterfaceEditPart.this.getLayer("Feedback Layer");
            layer.validate();
            newBounds.union(layer.getFreeformExtent());
            layer = (FreeformLayer)EditorWithInterfaceEditPart.this.getLayer("Handle Layer");
            layer.validate();
            newBounds.union(layer.getFreeformExtent());
            newBounds.shrink(EditorWithInterfaceEditPart.this.leftInterfaceContainer.getInsets());
            Rectangle resultingBounds = this.calculateModuloExtent(newBounds);
            figure.getParent().setConstraint(figure, (Object)new Rectangle(resultingBounds.x, resultingBounds.y, -1, -1));
            return resultingBounds.getSize();
        }

        private Rectangle calculateModuloExtent(Rectangle newBounds) {
            int x = this.calcAxisOrigin(newBounds.x, 400);
            int y = this.calcAxisOrigin(newBounds.y, 200);
            int width = this.calcAxisExtent(newBounds.x, x, newBounds.width, 400);
            int height = this.calcAxisExtent(newBounds.y, y, newBounds.height, 200);
            return new Rectangle(x, y, width, height);
        }

        private int calcAxisExtent(int baseOrigin, int newOrigin, int sourceExtent, int baseUnit) {
            int startExtent = sourceExtent + baseOrigin - newOrigin;
            int newExtend = (startExtent / baseUnit + 1) * baseUnit;
            if (newExtend < 3 * baseUnit) {
                newExtend = 3 * baseUnit;
            }
            return newExtend;
        }

        private int calcAxisOrigin(int axisPos, int baseUnit) {
            if (axisPos < 0) {
                return (axisPos / baseUnit - 1) * baseUnit;
            }
            return axisPos / baseUnit * baseUnit;
        }
    }

    private static class MinSizeFigure
    extends Figure {
        private MinSizeFigure() {
        }

        public Dimension getPreferredSize(int wHint, int hHint) {
            Dimension prefSize = super.getPreferredSize(wHint, hHint);
            prefSize.union(this.getMinimumSize());
            return prefSize;
        }
    }
}

