/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.hierarchymanager.build;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.fordiac.ide.hierarchymanager.build.HierarchyRuntimeModule;
import org.eclipse.fordiac.ide.hierarchymanager.build.HierarchyUiModule;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xtext.ui.shared.SharedStateModule;
import org.eclipse.xtext.util.Modules2;
import org.osgi.framework.BundleContext;

public class HierarchyBuildPlugin
extends AbstractUIPlugin {
    private static final Logger logger = Logger.getLogger(HierarchyBuildPlugin.class);
    private static HierarchyBuildPlugin instance;
    private final Map<String, Injector> injectors = Collections.synchronizedMap(HashMap.newHashMap(2));

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
    }

    public void stop(BundleContext context) throws Exception {
        this.injectors.clear();
        instance = null;
        super.stop(context);
    }

    public static HierarchyBuildPlugin getInstance() {
        return instance;
    }

    public Injector getInjector(String language) {
        return this.injectors.computeIfAbsent(language, this::createInjector);
    }

    protected Injector createInjector(String language) {
        try {
            Module runtimeModule = this.getRuntimeModule(language);
            Module sharedStateModule = this.getSharedStateModule();
            Module uiModule = this.getUiModule(language);
            Module mergedModule = Modules2.mixin((Module[])new Module[]{runtimeModule, sharedStateModule, uiModule});
            return Guice.createInjector((Module[])new Module[]{mergedModule});
        }
        catch (Exception e) {
            logger.error((Object)("Failed to create injector for " + language));
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException("Failed to create injector for " + language, e);
        }
    }

    protected Module getRuntimeModule(String grammar) {
        if ("org.eclipse.fordiac.ide.hierarchymanager.hierarchy".equals(grammar)) {
            return new HierarchyRuntimeModule();
        }
        throw new IllegalArgumentException(grammar);
    }

    protected Module getUiModule(String grammar) {
        if ("org.eclipse.fordiac.ide.hierarchymanager.hierarchy".equals(grammar)) {
            return new HierarchyUiModule(this);
        }
        throw new IllegalArgumentException(grammar);
    }

    protected Module getSharedStateModule() {
        return new SharedStateModule();
    }
}

