/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.parsetree.reconstr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STComment;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCommentPosition;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCoreFactory;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parsetree.reconstr.impl.DefaultCommentAssociater;

public class STCoreCommentAssociater
extends DefaultCommentAssociater {
    public List<STComment> associateComments(EObject model) {
        return this.associateCommentsWithSemanticEObjects(model).entrySet().stream().sorted(Comparator.comparingInt(entry -> ((ILeafNode)entry.getKey()).getOffset())).map(entry -> STCoreCommentAssociater.newComment((ILeafNode)entry.getKey(), (EObject)entry.getValue())).toList();
    }

    public Map<ILeafNode, EObject> associateCommentsWithSemanticEObjects(EObject model) {
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)model);
        if (node != null) {
            return this.associateCommentsWithSemanticEObjects(model, Set.of(node.getRootNode()));
        }
        return Collections.emptyMap();
    }

    protected static STComment newComment(ILeafNode commentNode, EObject semanticObject) {
        STComment comment = STCoreFactory.eINSTANCE.createSTComment();
        comment.setContext(semanticObject);
        comment.setText(commentNode.getText());
        comment.setPosition(STCoreCommentAssociater.computeRelativePosition(commentNode, semanticObject));
        return comment;
    }

    protected static STCommentPosition computeRelativePosition(ILeafNode commentNode, EObject semanticObject) {
        return STCoreCommentAssociater.computeRelativePosition(commentNode, NodeModelUtils.findActualNodeFor((EObject)semanticObject));
    }

    protected static STCommentPosition computeRelativePosition(ILeafNode commentNode, ICompositeNode semanticNode) {
        if (semanticNode != null) {
            if (STCoreCommentAssociater.isCommentBefore(commentNode, semanticNode)) {
                return STCommentPosition.BEFORE;
            }
            if (STCoreCommentAssociater.isCommentAfter(commentNode, semanticNode)) {
                return STCommentPosition.AFTER;
            }
            if (STCoreCommentAssociater.isCommentInner(commentNode, semanticNode)) {
                return STCommentPosition.INNER;
            }
        }
        return STCommentPosition.UNKNOWN;
    }

    protected void associateCommentsWithSemanticEObjects(Map<ILeafNode, EObject> mapping, ICompositeNode rootNode) {
        EObject currentEObject = null;
        ArrayList<ILeafNode> currentComments = new ArrayList<ILeafNode>();
        for (ILeafNode node : rootNode.getLeafNodes()) {
            EObject nextEObject;
            if (this.tokenUtil.isCommentNode((INode)node)) {
                currentComments.add(node);
                continue;
            }
            if (node.isHidden() || (nextEObject = this.tokenUtil.getTokenOwner((INode)node)) == null) continue;
            if (currentEObject == null) {
                this.addMapping(mapping, currentComments, nextEObject);
            } else {
                this.addMapping(mapping, currentComments, currentEObject, nextEObject);
            }
            currentEObject = nextEObject;
        }
        if (!currentComments.isEmpty()) {
            if (currentEObject != null) {
                this.addMapping(mapping, currentComments, currentEObject);
            } else {
                EObject objectForRemainingComments = this.getEObjectForRemainingComments(rootNode);
                if (objectForRemainingComments != null) {
                    this.addMapping(mapping, currentComments, objectForRemainingComments);
                }
            }
        }
    }

    protected void addMapping(Map<ILeafNode, EObject> mapping, List<ILeafNode> currentComments, EObject previousEObject, EObject nextEObject) {
        ICompositeNode previousNode = NodeModelUtils.findActualNodeFor((EObject)previousEObject);
        ICompositeNode nextNode = NodeModelUtils.findActualNodeFor((EObject)nextEObject);
        for (ILeafNode commentNode : currentComments) {
            boolean sameLine = STCoreCommentAssociater.isCommentSameLine(commentNode, previousNode);
            boolean afterPrevious = STCoreCommentAssociater.isCommentAfter(commentNode, previousNode);
            boolean beforeNext = STCoreCommentAssociater.isCommentBefore(commentNode, nextNode);
            if (sameLine && afterPrevious || !beforeNext && (afterPrevious || sameLine)) {
                mapping.put(commentNode, previousEObject);
                continue;
            }
            mapping.put(commentNode, nextEObject);
        }
        currentComments.clear();
    }

    protected static boolean isCommentSameLine(ILeafNode commentNode, ICompositeNode semanticNode) {
        return commentNode.getStartLine() == semanticNode.getEndLine();
    }

    protected static boolean isCommentBefore(ILeafNode commentNode, ICompositeNode semanticNode) {
        return commentNode.getEndOffset() <= semanticNode.getOffset();
    }

    protected static boolean isCommentAfter(ILeafNode commentNode, ICompositeNode semanticNode) {
        return commentNode.getOffset() >= semanticNode.getEndOffset();
    }

    protected static boolean isCommentInner(ILeafNode commentNode, ICompositeNode semanticNode) {
        return commentNode.getOffset() > semanticNode.getOffset() && commentNode.getEndOffset() < semanticNode.getEndOffset();
    }
}

