/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.model.commands.QualNameAffectedCommand;
import org.eclipse.fordiac.ide.model.commands.QualNameChange;
import org.eclipse.fordiac.ide.model.commands.QualNameChangeListener;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteFBNetworkElementCommand;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.ui.editors.EditorFilter;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.ui.IEditorPart;

public enum QualNameChangeListenerManager implements CommandStackEventListener
{
    INSTANCE;

    private static final String EXTENSION_POINT_ID = "org.eclipse.fordiac.ide.model.commands.QualNameChangeListener";
    private final List<QualNameChangeListener> listeners = new ArrayList<QualNameChangeListener>();

    private QualNameChangeListenerManager() {
        this.initializeListeners();
    }

    private void initializeListeners() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Object obj = element.createExecutableExtension("class");
                if (obj instanceof QualNameChangeListener) {
                    QualNameChangeListener l = (QualNameChangeListener)obj;
                    this.listeners.add(l);
                }
            }
            catch (Exception e) {
                FordiacLogHelper.logError((String)EXTENSION_POINT_ID, (Throwable)e);
            }
            ++n2;
        }
    }

    public static void addCommandStackEventListener(CommandStack commandStack) {
        commandStack.addCommandStackEventListener((CommandStackEventListener)INSTANCE);
    }

    public void removeCommandStackEventListener(CommandStack commandStack, Object notfier) {
        this.listeners.forEach(l -> l.flush(notfier));
        commandStack.removeCommandStackEventListener((CommandStackEventListener)INSTANCE);
    }

    public void stackChanged(CommandStackEvent event) {
        CommandStack stack;
        TypeEntry typeEntry;
        Object object;
        CommandStack stack2;
        TypeEntry typeEntry2;
        Object object2;
        Command command = event.getCommand();
        if (command instanceof CompoundCommand) {
            CompoundCommand cmd = (CompoundCommand)command;
            for (Command c : cmd.getCommands()) {
                CommandStack stack3 = (CommandStack)event.getSource();
                this.stackChanged(new CommandStackEvent(stack3, c, event.getDetail()));
            }
            return;
        }
        Command command2 = event.getCommand();
        if (command2 instanceof DeleteFBNetworkElementCommand) {
            DeleteFBNetworkElementCommand cmd = (DeleteFBNetworkElementCommand)command2;
            switch (event.getDetail()) {
                case 1: {
                    this.notifyListenersExecute(cmd.getQualNameChanges(QualNameChangeListener.QualNameChangeState.DELETE));
                    break;
                }
                case 32: {
                    this.notifyListenersExecute(cmd.getQualNameChanges(QualNameChangeListener.QualNameChangeState.DELETE_UNDO));
                    break;
                }
                case 2: {
                    this.notifyListenersExecute(cmd.getQualNameChanges(QualNameChangeListener.QualNameChangeState.DELETE_REDO));
                    break;
                }
            }
        } else {
            Command command3 = event.getCommand();
            if (command3 instanceof QualNameAffectedCommand) {
                QualNameAffectedCommand cmd = (QualNameAffectedCommand)command3;
                switch (event.getDetail()) {
                    case 8: {
                        this.notifyListenersExecute(cmd.getQualNameChanges(QualNameChangeListener.QualNameChangeState.RENAME));
                        break;
                    }
                    case 32: {
                        this.notifyListenersUndo(cmd.getQualNameChanges(QualNameChangeListener.QualNameChangeState.RENAME_UNDO));
                        break;
                    }
                    case 16: {
                        this.notifyListenersRedo(cmd.getQualNameChanges(QualNameChangeListener.QualNameChangeState.RENAME_REDO));
                        break;
                    }
                }
            }
        }
        if (event.getDetail() == 512 && (object2 = event.getSource()) instanceof CommandStack && (typeEntry2 = QualNameChangeListenerManager.getTypeEntryKeyFromCommandStack(stack2 = (CommandStack)object2)) != null) {
            this.notifiyCommit(typeEntry2);
        }
        if (event.getDetail() == 256 && (object = event.getSource()) instanceof CommandStack && (typeEntry = QualNameChangeListenerManager.getTypeEntryKeyFromCommandStack(stack = (CommandStack)object)) != null) {
            this.listeners.forEach(l -> l.flush(typeEntry));
        }
    }

    private static TypeEntry getTypeEntryKeyFromCommandStack(CommandStack stack) {
        EditorFilter filter = editor -> editor.getAdapter(CommandStack.class) == stack;
        IEditorPart[] currentActiveEditors = EditorUtils.findEditor((EditorFilter)filter);
        if (currentActiveEditors.length > 0) {
            LibraryElement libraryElement = (LibraryElement)currentActiveEditors[0].getAdapter(LibraryElement.class);
            return libraryElement.getTypeEntry();
        }
        return null;
    }

    public void notifyListenersExecute(List<QualNameChange> qualNameChange) {
        for (QualNameChangeListener listener : this.listeners) {
            listener.onCommandExecuted(qualNameChange);
        }
    }

    public void notifyListenersUndo(List<QualNameChange> qualNameChange) {
        for (QualNameChangeListener listener : this.listeners) {
            listener.onCommandUndoExecuted(qualNameChange);
        }
    }

    public void notifyListenersRedo(List<QualNameChange> qualNameChange) {
        for (QualNameChangeListener listener : this.listeners) {
            listener.onCommandRedoExecuted(qualNameChange);
        }
    }

    void notifiyCommit(Object notfier) {
        for (QualNameChangeListener listener : this.listeners) {
            listener.commitOperations(notfier);
        }
    }
}

